/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.license;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.file.ZipIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import ordermate.OrderMate;
import ordermate.security.impl.LicenceExceptionHandler;
import ordermate.security.impl.SecurityDetails;
import ordermate.security.impl.SecurityManager;
import servermate.gui.license.SecurityDetailsService;

public class SilentSecurity {
    public static void main(String[] args) {
        if (args.length > 0) {
            if (!Config.isConfigSetup()) {
                try {
                    Config.readConfigData((String)"ServermateConfig.ini");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            SilentSecurity.readInFile(new File(args[0]));
        }
    }

    public static boolean readInFile(File file) {
        return SilentSecurity.readInFile(file, null);
    }

    public static boolean readInFile(File file, SecurityDetails securityDetails) {
        Hashtable serverCfg = new Hashtable();
        Hashtable oldCfg = new Hashtable();
        try {
            serverCfg = Config.readConfigData((String)"ServermateConfig.ini", serverCfg);
            oldCfg = Config.getTheConfig();
            Config.setTheConfig((Hashtable)serverCfg);
            SilentSecurity.initManager();
            Config.setTheConfig((Hashtable)oldCfg);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't read in the file, error setting configs", (Throwable)ex);
            return false;
        }
        ZipIO io = new ZipIO(OrderMate.LOG);
        try {
            SecurityDetailsService service = securityDetails == null ? new SecurityDetailsService() : new SecurityDetailsService(securityDetails);
            String data = io.readInFromFile(file);
            if (data == null) {
                OrderMate.LOG.info("Licence File not found ignoring");
                data = "";
            }
            return service.importDetails(data);
        }
        catch (FileNotFoundException e) {
            OrderMate.LOG.error("Couldn't read in the file, does not exist", (Throwable)e);
            return false;
        }
    }

    private static void initManager() {
        if (!SecurityManager.isInitialised()) {
            SecurityManager.initialise((SecurityManager.SecurityMode)SecurityManager.SecurityMode.Normal, null, (LicenceExceptionHandler)new LicenceExceptionHandler(){

                public void handleException(int minutesLeft) {
                }

                public boolean staleActingMaster() {
                    return false;
                }
            });
        }
    }
}

