/*
 * Decompiled with CFR 0.152.
 */
package servermate.gui.redback;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.nudge.NudgeHelper;
import ordermate.internationalization.Internationalization;
import servermate.gui.redback.RedbackIdWorker;

public class RedbackIdDialog
extends JDialog
implements ActionListener {
    private final String LONG_FORMAT = "########################################";
    private JLabel lbl_RedbackId;
    private JLabel lbl_Status;
    private JLabel lbl_Label;
    private JLabel lbl_Location;
    private JLabel lbl_Address;
    private JButton verifyButton;
    private JButton setButton;
    private JButton closeButton;
    private JFormattedTextField text_RedbackId;
    private JTextField text_Label;
    private JTextField text_Location;
    private JTextField text_Address;
    private JPanel panel_RedbackDetails;
    private JPanel buttonPanel = new JPanel();
    private final Window parent;
    private GridBagConstraints gbc = new GridBagConstraints();

    public RedbackIdDialog(Window parent) {
        super(parent);
        this.parent = parent;
        this.initComponents();
        this.initGUI();
        this.initGUI();
        this.setDefaultCloseOperation(2);
        this.setSize(400, 250);
    }

    private JLabel initLabel(String label) {
        return new JLabel(label, 11);
    }

    private JTextField createTextField() {
        return new JTextField();
    }

    private JFormattedTextField getFormattexTextField() {
        JFormattedTextField formattedTextField = null;
        try {
            formattedTextField = new JFormattedTextField(new MaskFormatter("########################################"));
            formattedTextField.setFocusLostBehavior(0);
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return formattedTextField;
    }

    private String getString(String key) {
        return Internationalization.getLiteralFor((String)key);
    }

    public void initComponents() {
        this.lbl_RedbackId = this.initLabel(this.getString("STORE_ID"));
        this.text_RedbackId = this.getFormattexTextField();
        this.lbl_Label = this.initLabel(this.getString("NAME"));
        this.text_Label = this.createTextField();
        this.lbl_Location = this.initLabel(this.getString("LABEL"));
        this.text_Location = this.createTextField();
        this.lbl_Address = this.initLabel(this.getString("ADDRESS"));
        this.text_Address = this.createTextField();
        this.panel_RedbackDetails = new JPanel();
        this.lbl_Status = new JLabel(this.getString("ENTER_STORE_ID"));
        this.verifyButton = new JButton(this.getString("VERIFY"));
        this.closeButton = new JButton(this.getString("CLOSE"));
        this.setButton = new JButton(this.getString("SET"));
    }

    private GridBagConstraints getConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 10, 0, 10);
        return gbc;
    }

    private GridBagConstraints getConstrainsForLabel(int rowCount) {
        GridBagConstraints gbc = this.getConstraints();
        gbc.gridy = rowCount;
        gbc.insets = new Insets(10, 10, 0, 10);
        return gbc;
    }

    private GridBagConstraints getConstraintsForTextField(int rowCount) {
        GridBagConstraints gbc = this.getConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 0;
        gbc.gridy = rowCount;
        gbc.weightx = 0.9;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 10);
        return gbc;
    }

    private void addPair(JLabel label, JTextField text, int rowCount) {
        this.gbc = this.getConstrainsForLabel(rowCount);
        this.panel_RedbackDetails.add((Component)label, this.gbc);
        label.setLabelFor(text);
        this.gbc = this.getConstraintsForTextField(rowCount);
        this.panel_RedbackDetails.add((Component)text, this.gbc);
    }

    private void addButtonPanel() {
        this.buttonPanel.add(this.setButton);
        this.buttonPanel.add(this.closeButton);
        this.verifyButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.setButton.addActionListener(this);
        this.add((Component)this.buttonPanel, "South");
    }

    private void addStatusLabel(int rowCount) {
        this.gbc = this.getConstraintsForTextField(rowCount);
        this.panel_RedbackDetails.add((Component)this.lbl_Status, this.gbc);
    }

    private void enableComponents(boolean enable) {
        this.text_Label.setEnabled(false);
        this.text_Location.setEnabled(false);
        this.text_Address.setEnabled(false);
    }

    public void initGUI() {
        this.setTitle(this.getString("SCREEN_SET_STORE_ID"));
        this.setLayout(new BorderLayout());
        this.panel_RedbackDetails.setLayout(new GridBagLayout());
        this.gbc = this.getConstrainsForLabel(0);
        this.panel_RedbackDetails.add((Component)this.lbl_RedbackId, this.gbc);
        this.lbl_RedbackId.setLabelFor(this.text_RedbackId);
        this.gbc = this.getConstraintsForTextField(0);
        this.gbc.gridwidth = -1;
        this.panel_RedbackDetails.add((Component)this.text_RedbackId, this.gbc);
        GridBagConstraints gbc = this.getConstraintsForTextField(0);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 3;
        this.panel_RedbackDetails.add((Component)this.verifyButton, gbc);
        this.addPair(this.lbl_Label, this.text_Label, 1);
        this.addPair(this.lbl_Location, this.text_Location, 2);
        this.addPair(this.lbl_Address, this.text_Address, 3);
        this.addStatusLabel(5);
        this.add((Component)this.panel_RedbackDetails, "Center");
        this.addButtonPanel();
        this.enableComponents(false);
        this.setButton.setEnabled(false);
        this.setLocationRelativeTo(null);
        this.text_RedbackId.setText("");
        this.setButton.setSize(this.closeButton.getSize());
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.closeDialog();
        } else if (source == this.verifyButton) {
            this.verifyId();
        } else if (source == this.setButton) {
            this.setStoreId();
        }
    }

    private void setStoreId() {
        try {
            SystemCurrentInfo.getInstance().setRedbackId(new Long(this.text_RedbackId.getText().trim()).longValue());
            SystemCurrentInfo.getInstance().save();
            this.lbl_Status.setText(this.getString("STORE_ID_SUCCESS"));
            new NudgeHelper().setNudgeServiceAsDefault();
        }
        catch (Exception ex) {
            this.lbl_Status.setText("Error : " + ex.getMessage());
        }
    }

    private void verifyId() {
        if (this.text_RedbackId.getText().trim().length() == 0) {
            this.lbl_Status.setText(this.getString("ENTER_VALID_STOREID"));
            return;
        }
        Long storeId = new Long(this.text_RedbackId.getText().trim());
        RedbackIdWorker redbackIdWorker = new RedbackIdWorker(storeId);
        try {
            redbackIdWorker.execute();
            Map storeDetails = (Map)redbackIdWorker.get(30L, TimeUnit.SECONDS);
            if (storeDetails == null) {
                this.setButton.setEnabled(false);
                this.lbl_Status.setText(redbackIdWorker.getErrorMessage());
                this.text_Label.setText("");
                this.text_Location.setText("");
                this.text_Address.setText("");
            } else {
                this.setButton.setEnabled(true);
                this.lbl_Status.setText(this.getString("CLICK_SET_BUTTON"));
                this.text_Label.setText((String)storeDetails.get("label"));
                this.text_Location.setText((String)storeDetails.get("location"));
                this.text_Address.setText((String)storeDetails.get("address"));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

