/*
 * Decompiled with CFR 0.152.
 */
package servermate.integrity;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import servermate.ServerMate;

public class InventoryItemCheck {
    public void check() {
        this.checkName();
        this.checkNotMissingIntoUnit();
        this.checkNoPriceForUnit();
    }

    void checkName() {
        List<InventoryItem> result = this.retrieveNullName();
        for (InventoryItem item : result) {
            ServerMate.LOG.warn("The item ID " + item.getID() + " had a null name.");
            item.setLabel("");
            item.save();
        }
    }

    void checkNotMissingIntoUnit() {
        List<InventoryItemUnit> result = this.retrieveBrokenLink();
        for (InventoryItemUnit unit : result) {
            try {
                ServerMate.LOG.warn("The item unit ID " + unit.getID() + " had a broken link to the item.");
                unit.setSystemState("DELETED");
                unit.saveChild();
            }
            catch (Exception ex) {
                ServerMate.LOG.warn("Ooops", (Throwable)ex);
            }
        }
    }

    void checkNoPriceForUnit() {
        List<InventoryItemUnit> result = this.retrieveNoPriceItemUnit();
        for (InventoryItemUnit unit : result) {
            try {
                ServerMate.LOG.warn("This item unit has no price:" + unit.getID());
                unit.setSystemState("DELETED");
                unit.saveChild();
            }
            catch (Exception ex) {
                ServerMate.LOG.warn("Error with setting InventoryItemUnit with no Price to Deleted", (Throwable)ex);
            }
        }
    }

    List<InventoryItemUnit> retrieveBrokenLink() {
        String query = Query.select(InventoryItemUnit.class).joinLeft(InventoryItem.class, InventoryItemUnit.Properties.ITEM).isNull(InventoryItem.Properties.ID).active(InventoryItemUnit.class).toString();
        List result = PersistenceManager.getObjectList(InventoryItemUnit.class, (String)query, null);
        return result;
    }

    List<InventoryItem> retrieveNullName() {
        String query = Query.select(InventoryItem.class).isNull(InventoryItem.Properties.LABEL).toString();
        List result = PersistenceManager.getObjectList(InventoryItem.class, (String)query, null);
        return result;
    }

    List<InventoryItemUnit> retrieveNoPriceItemUnit() {
        String query = Query.select(InventoryItemUnit.class).joinLeft(UnitPriceLevel.class, InventoryItemUnit.Properties.PRICES).active(InventoryItemUnit.class).isNull(UnitPriceLevel.Properties.UNIT).toString();
        List results = PersistenceManager.getObjectList(InventoryItemUnit.class, (String)query, null);
        return results;
    }
}

