/*
 * Decompiled with CFR 0.152.
 */
package servermate.integrity;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.database.datasourcefactory.ConfigDataSourceFactory;
import au.com.ordermate.persistence.database.datasourcefactory.DataSourceFactory;
import java.sql.SQLException;
import java.util.Collection;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentFactory;
import ordermate.dbconnection.AbstractDatabaseConnection;

public class SalesPriceAdjustmentCheck {
    private final String SELECT_INVALID = "select sales_price_adjustment.ID, sales_price_adjustment.amount, sales_price_adjustment.unit, sales_price_adjustment.direction from sales_price_adjustment left join inventory_price_adjustment on inventory_price_adjustment.ID = sales_price_adjustment.FK_inventory_price_adjustment where inventory_price_adjustment.ID IS NULL";
    private Collection units;

    public void check() throws SQLException {
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery("select sales_price_adjustment.ID, sales_price_adjustment.amount, sales_price_adjustment.unit, sales_price_adjustment.direction from sales_price_adjustment left join inventory_price_adjustment on inventory_price_adjustment.ID = sales_price_adjustment.FK_inventory_price_adjustment where inventory_price_adjustment.ID IS NULL", new Object[0]);
        for (int i = 0; i < result.length; ++i) {
            InventoryPriceAdjustment missing;
            Double amount = (Double)result[i][1];
            PriceAdjustmentUnit unit = this.getUnit((String)result[i][2]);
            String direction = (String)result[i][3];
            if (amount == null) {
                OrderMate.LOG.error("sales_price_adjustment " + result[i][0] + " has an invalid amount and cannot be repaired.");
                continue;
            }
            if (unit == null) {
                OrderMate.LOG.error("sales_price_adjustment " + result[i][0] + " has an invalid unit and cannot be repaired.");
                continue;
            }
            if (direction == null || !direction.equals("DISCOUNT") && !direction.equals("SURCHARGE")) {
                OrderMate.LOG.error("sales_price_adjustment " + result[i][0] + " has an invalid direction and cannot be repaired.");
                continue;
            }
            if (direction.equals("DISCOUNT")) {
                if (unit.equals((Object)PriceAdjustmentUnit.PERCENTAGE_UNIT) && amount > 100.0) {
                    amount = new Double(100.0);
                }
                missing = PriceAdjustmentFactory.getInstance().createCustomDiscount(amount.doubleValue(), unit);
            } else {
                missing = PriceAdjustmentFactory.getInstance().createCustomSurcharge(amount.doubleValue(), unit);
            }
            missing.save();
            AbstractDatabaseConnection.getDBConnectionInterface((DataSourceFactory)ConfigDataSourceFactory.getInstance()).execute("UPDATE sales_price_adjustment set fk_inventory_price_adjustment = " + missing.intID() + " where ID = " + result[i][0]);
            OrderMate.LOG.error("sales_price_adjustment " + result[i][0] + " was invalid and a new inventory_price_adjustment has been created.");
        }
    }

    private PriceAdjustmentUnit getUnit(String label) {
        if (label == null) {
            return null;
        }
        if (this.units == null) {
            this.units = PriceAdjustmentUnit.getAll();
        }
        for (PriceAdjustmentUnit unit : this.units) {
            if (!unit.getLabel().equals(label)) continue;
            return unit;
        }
        return null;
    }
}

