/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import java.util.ArrayList;
import java.util.Collection;
import ordermate.database.message.ScheduledMessage;
import ordermate.database.misc.SystemProperty;
import servermate.message.MessageReceiver;
import servermate.message.MessageScheduler;
import servermate.message.MessageTask;

public class ChangeUpdater {
    private static ChangeUpdater updater;
    private boolean running;
    private final long PERIOD;

    private ChangeUpdater() {
        SystemProperty props = SystemProperty.getInstance();
        this.running = false;
        this.PERIOD = props.getMessageUpdaterPollTime() * 1000;
    }

    public void start() {
        if (this.running) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(ChangeUpdater.this.PERIOD);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        ChangeUpdater.this.execute();
                        continue;
                    }
                    catch (Exception e) {
                        String s = "Unhandled Exception in ChangeUpdater!";
                        MessageReceiver.COMMAND_LOG.error((Object)s, (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setName("ChangeUpdater Thread.");
        thread.start();
        this.running = true;
    }

    private void execute() {
        MessageScheduler scheduler = MessageScheduler.getInstance();
        Collection schedTasks = scheduler.getTasks();
        ArrayList messages = new ArrayList(ScheduledMessage.getScheduledMessages());
        ArrayList<MessageTask> dbaseTasks = new ArrayList<MessageTask>();
        for (ScheduledMessage msg : messages) {
            dbaseTasks.add(new MessageTask(msg));
        }
        ArrayList<MessageTask> modify = new ArrayList<MessageTask>();
        ArrayList<MessageTask> remove = new ArrayList<MessageTask>();
        ArrayList<MessageTask> insert = new ArrayList<MessageTask>();
        for (MessageTask current : schedTasks) {
            if (dbaseTasks.contains(current)) {
                modify.add(current);
                continue;
            }
            remove.add(current);
        }
        for (MessageTask current : dbaseTasks) {
            if (schedTasks.contains(current)) continue;
            insert.add(current);
        }
        for (MessageTask current : modify) {
            MessageTask updated = new MessageTask(ScheduledMessage.getScheduledMessage((Long)current.getMessage().getID()));
            if (updated.getScheduledTime().equals(current.getScheduledTime())) {
                current.update(updated);
                continue;
            }
            remove.add(current);
            insert.add(updated);
        }
        for (MessageTask current : remove) {
            scheduler.removeTask(current);
        }
        for (MessageTask current : insert) {
            scheduler.addTask(current);
        }
    }

    public static ChangeUpdater getInstance() {
        if (updater == null) {
            updater = new ChangeUpdater();
        }
        return updater;
    }
}

