/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.message.SMS;
import ordermate.OrderMate;
import ordermate.database.message.SmsProvider;
import ordermate.database.misc.SystemProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import servermate.message.CommandDispatcher;

public class MessageReceiver {
    private static MessageReceiver messageReceiver;
    private final long PERIOD = SystemProperty.getInstance().getMessageServerPollTime() * 1000;
    private boolean running = false;
    public static final Log COMMAND_LOG;

    private MessageReceiver() {
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        String s;
        if (this.isRunning()) {
            return;
        }
        MessageServer messageServer = MessageServer.getServer();
        messageServer.connect();
        if (messageServer.isConnected()) {
            s = "Initial message server connect succeeded.";
            COMMAND_LOG.info((Object)s);
        } else {
            s = "Initial message server connect FAILED!";
            COMMAND_LOG.info((Object)s);
        }
        Thread worker = new Thread(new Runnable(){

            @Override
            public void run() {
                MessageReceiver.this.execute();
            }
        });
        worker.start();
        this.running = true;
    }

    /*
     * Unable to fully structure code
     */
    private void execute() {
        messageServer = MessageServer.getServer();
        if (!messageServer.isPopServerConfigured()) {
            OrderMate.LOG.info("Pop3 is not configured, will not attempt to receive messages");
            return;
        }
        while (true) {
            try {
                block5: while (true) {
                    try {
                        Thread.sleep(this.PERIOD);
                    }
                    catch (InterruptedException var2_3) {
                        // empty catch block
                    }
                    if (!messageServer.isConnected()) {
                        messageServer.connect();
                        if (messageServer.isConnected()) {
                            s = "MessageServer connected.";
                            MessageReceiver.COMMAND_LOG.info((Object)s);
                        } else {
                            s = "Unable to connect MessageServer. Will attempt to connect next cycle.";
                            MessageReceiver.COMMAND_LOG.info((Object)s);
                        }
                    }
                    if (!messageServer.isPop3Connected()) continue;
                    emails = messageServer.receiveMails("inbox");
                    if (emails.length > 0) {
                        s = "Received " + emails.length + " email(s) to process from server.";
                        MessageReceiver.COMMAND_LOG.info((Object)s);
                    }
                    i = 0;
                    while (true) {
                        if (i < emails.length) ** break;
                        continue block5;
                        this.processEmail(emails[i]);
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception e) {
                s = "Unhandled exception is MessageHandler!";
                MessageReceiver.COMMAND_LOG.info((Object)s, (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void processEmail(Email email) {
        if (email == null) {
            return;
        }
        String text = email.getText();
        if (text != null) {
            CommandDispatcher.getInstance().dispatchReplyRequest(text, email);
        }
    }

    public static MessageReceiver getInstance() {
        if (messageReceiver == null) {
            messageReceiver = new MessageReceiver();
        }
        return messageReceiver;
    }

    static {
        COMMAND_LOG = LogFactory.getLog(MessageReceiver.class);
        SmsProvider provider = SmsProvider.getProvider();
        SMS.setup((String)provider.getEmailSuffix(), (String)provider.getSubject(), (String)provider.getSenderEmail(), (String)provider.getSenderName());
    }
}

