/*
 * Decompiled with CFR 0.152.
 */
package servermate.message;

import au.com.ordermate.message.MessageServer;
import au.com.ordermate.message.SMS;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimerTask;
import ordermate.database.message.MessageDestination;
import ordermate.database.message.ScheduledMessage;
import ordermate.database.message.SmsProvider;
import servermate.message.CommandDispatcher;
import servermate.message.MessageReceiver;

public class MessageTask
extends TimerTask {
    private ScheduledMessage message;

    public MessageTask(ScheduledMessage schedMessage) {
        if (schedMessage == null) {
            String s = "message cannot be null!";
            throw new IllegalArgumentException(s);
        }
        this.message = schedMessage;
    }

    public void update(MessageTask other) {
        if (other == null) {
            String s = "other cannot be null!";
            throw new IllegalArgumentException(s);
        }
        if (other.getMessage().getID().intValue() != this.getMessage().getID().intValue()) {
            String s = "other message has invalid ID!";
            throw new IllegalArgumentException(s);
        }
        this.message = other.getMessage();
    }

    public Date getScheduledTime() {
        Calendar toReturn = Calendar.getInstance();
        GregorianCalendar messageTime = new GregorianCalendar();
        messageTime.setTime(this.message.getTime());
        toReturn.set(10, messageTime.get(10));
        toReturn.set(12, messageTime.get(12));
        toReturn.set(13, messageTime.get(13));
        toReturn.set(9, messageTime.get(9));
        return toReturn.getTime();
    }

    @Override
    public void run() {
        String text = CommandDispatcher.getInstance().dispatchResponseRequest(this.message.getCommand());
        MessageServer server = MessageServer.getServer();
        for (MessageDestination messageDestination : this.message.getDestinations()) {
            String destination = messageDestination.getDestination();
            SMS sms = new SMS();
            sms.setPhoneNumber(destination);
            sms.setText(text);
            boolean sent = false;
            if (this.getSmsProviderSettings().getProviderType().equals((Object)SmsProvider.SMSProviderType.Email)) {
                if (!server.isSmtpConnected()) {
                    server.connect();
                }
                if (server.isSmtpConnected()) {
                    sent = server.send(sms.createMessage(server.getSession()));
                } else {
                    this.logNotConnected(destination);
                }
            } else {
                sent = sms.sendSMSviaHTTP(false);
            }
            if (sent) {
                this.logSendSuccess(destination);
                sms.logSend();
                continue;
            }
            this.logSendFailure(destination);
        }
    }

    public ScheduledMessage getMessage() {
        return this.message;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageTask) {
            MessageTask other = (MessageTask)obj;
            return this.getMessage().getID().equals(other.getMessage().getID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getMessage() != null && this.getMessage().getID() != null) {
            return this.getMessage().getID().intValue();
        }
        return super.hashCode();
    }

    private void logNotConnected(String destination) {
        String msg = "Unable to send scheduled message " + this.message.getCommand().getCommand() + " to " + destination + " as server was not connected.";
        MessageReceiver.COMMAND_LOG.info((Object)msg);
    }

    private void logSendSuccess(String destination) {
        String msg = "Scheduled message " + this.message.getCommand().getCommand() + " successfully sent to " + destination;
        MessageReceiver.COMMAND_LOG.info((Object)msg);
    }

    private void logSendFailure(String destination) {
        String msg = "Unable to send scheduled message " + this.message.getCommand().getCommand() + " to " + destination + " as send failed.";
        MessageReceiver.COMMAND_LOG.info((Object)msg);
    }

    private SmsProvider getSmsProviderSettings() {
        return SmsProvider.getProvider();
    }
}

