/*
 * Decompiled with CFR 0.152.
 */
package servermate.scripts;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import ordermate.OrderMate;
import servermate.scripts.UpdateMateScript;
import updatemate.client.ClientUpdateWSClient;
import updatemate.database.installationstate.InstallationStates;
import updatemate.security.ScriptSigner;

class UpdateMateScriptProcessor {
    private GroovyClassLoader classLoader = new GroovyClassLoader();
    private ClientUpdateWSClient clientUpdateWS;

    public UpdateMateScriptProcessor(ClientUpdateWSClient updater) {
        this.clientUpdateWS = updater;
    }

    public boolean process(File groovyFile) {
        OrderMate.LOG.info("Processing UpdateMate Script - " + groovyFile.getName());
        try {
            UpdateMateScript script = this.getUpdateMateScriptFromFile(groovyFile.getAbsolutePath());
            ScriptSigner signer = new ScriptSigner();
            if (signer.validateScript(groovyFile.getAbsolutePath())) {
                if (script.checkShouldRun()) {
                    boolean result = this.runScript(script);
                    OrderMate.LOG.info("Completed script - " + script.getName() + ", run with result: " + result);
                    return result;
                }
                OrderMate.LOG.info(script.getName() + " does not need to run.");
            } else {
                OrderMate.LOG.info(script.getName() + " - Script failed security check.");
                this.updateScriptRequestState(InstallationStates.FAILED.name());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured running script", (Throwable)ex);
            this.updateScriptRequestState(InstallationStates.FAILED.name());
        }
        return false;
    }

    private UpdateMateScript getUpdateMateScriptFromFile(String scriptFilePath) {
        try {
            StringBuilder scriptContents = new StringBuilder();
            new ScriptSigner().getFileContents(scriptFilePath, scriptContents);
            return (UpdateMateScript)this.classLoader.parseClass(scriptContents.toString()).newInstance();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error loading UpdateMate groovy Script.", (Throwable)ex);
            return null;
        }
    }

    private boolean runScript(UpdateMateScript script) {
        OrderMate.LOG.info("Running script - " + script.getName());
        this.updateScriptRequestState(InstallationStates.COMMENCED.name());
        boolean result = script.run();
        if (result) {
            this.updateScriptRequestState(InstallationStates.SUCCESS.name());
            if (script.shouldUploadResults() && this.clientUpdateWS != null && this.clientUpdateWS.uploadScriptResult(script.getResultsFile())) {
                this.updateScriptRequestState("UPLOADED");
            }
        } else {
            this.updateScriptRequestState(InstallationStates.FAILED.name());
        }
        return result;
    }

    private void updateScriptRequestState(String newState) {
        if (this.clientUpdateWS != null) {
            this.clientUpdateWS.updateScriptResultStatus(newState);
        }
    }
}

