/*
 * Decompiled with CFR 0.152.
 */
package servermate.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import servermate.gui.ServerMateFrame;

class ErrorFrame
extends JDialog {
    private final Signal pwdVerifiedSignal = Signals.createSignal();
    private final Timer autoCloseTimer;
    private static final int AUTO_CLOSE_TIME = 30000;

    ErrorFrame() {
        this.setTitle("Security Check Failure");
        this.setModal(true);
        JPanel holder = new JPanel(new BorderLayout());
        this.getContentPane().add(holder);
        JPanel centre = new JPanel(new FlowLayout());
        JLabel label = new JLabel("<html><h1>Security Check Failure</h1></html>");
        centre.add(label);
        holder.add(centre);
        this.getContentPane().add(holder);
        this.setSize(400, 400);
        JPanel butHolder = new JPanel(new FlowLayout());
        final JButton button = new JButton("Licence Options");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == button) {
                    ServerMateFrame.softwareLicense(ErrorFrame.this, ErrorFrame.this.pwdVerifiedSignal);
                }
            }
        });
        butHolder.add(button);
        holder.add((Component)butHolder, "North");
        this.pwdVerifiedSignal.connect((Object)this, "gotPwdVerified");
        this.autoCloseTimer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorFrame.this.setVisible(false);
                ErrorFrame.this.dispose();
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            OrderMate.LOG.info("Starting ServerMate Security Manager auto close timer.");
            this.autoCloseTimer.start();
        }
        super.setVisible(visible);
    }

    private void gotPwdVerified() {
        OrderMate.LOG.info("Stopping ServerMate Security Manager auto close timer.");
        this.autoCloseTimer.stop();
    }
}

