/*
 * Decompiled with CFR 0.152.
 */
package servermate.security;

import ordermate.OrderMate;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.security.impl.SecurityManager;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublisher;
import servermate.events.ServerMateEventType;

public class PersistentLicenseChecker
implements Runnable {
    private static final long PERIOD = 300000L;
    private static Thread killThread;
    LicenseState currentState = null;

    public static boolean check() {
        try {
            boolean licenseCheckValid = PersistentLicenseManager.getInstance().isValid(SecurityManager.getSecurityDetails().getLicenseHash(), SecurityManager.getSecurityDetails().getRecordedMacAddress());
            OrderMate.LOG.info("PersistentLicenseChecker : Valid : " + licenseCheckValid);
            if (licenseCheckValid) {
                PersistentLicenseChecker.resetKillThreadIfRunning();
            }
            return licenseCheckValid;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't read the security hash details!", (Throwable)ex);
            return false;
        }
    }

    private static void resetKillThreadIfRunning() {
        if (killThread != null && killThread.isAlive()) {
            killThread.interrupt();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException e) {
                SecurityManager.SECURITY_LOG.warn("DongleThread sleep cycle interrupted.", (Throwable)e);
                Thread.interrupted();
            }
            if (!PersistentLicenseChecker.check()) {
                OrderMate.LOG.warn("PersistenceLicenseChecker :: Starting Servermate Kill thread since Servermate License check has failed");
                boolean started = this.startKillThread();
                ServerMateEventPublisher.publishEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "Will be killed in 15 minutes", 1));
                this.setCurrentState(LicenseState.INVALID);
                continue;
            }
            this.setCurrentState(LicenseState.VALID);
            PersistentLicenseChecker.resetKillThreadIfRunning();
        }
    }

    private void setCurrentState(LicenseState newState) {
        if (this.currentState != null) {
            switch (this.currentState) {
                case VALID: {
                    if (newState != LicenseState.INVALID) break;
                    ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "", 1));
                    break;
                }
                case INVALID: {
                    if (newState != LicenseState.VALID) break;
                    ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.LICENSE_SUCCESSFUL, "", 1));
                }
            }
        }
        this.currentState = newState;
    }

    public static Thread startThread() {
        Thread thread = new Thread((Runnable)new PersistentLicenseChecker(), "License Check");
        thread.start();
        return thread;
    }

    private boolean startKillThread() {
        if (killThread == null || !killThread.isAlive()) {
            killThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        block5: {
                            try {
                                OrderMate.LOG.warn("Servermate has started the kill thread since license is not valid.");
                                ServerMateEventPublisher.publishEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "License Expired", 1));
                                ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "License Expired", 1));
                                Thread.sleep(1800000L);
                                ServerMateEventPublisher.publishEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "License Expired", 1));
                                ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "License Expired", 1));
                            }
                            catch (InterruptedException ex) {
                                if (PersistentLicenseChecker.check()) break block5;
                                SecurityManager.SECURITY_LOG.error("Security check failed: Kill thread interrupted and license still not valid - " + PersistentLicenseManager.getInstance().toString());
                                ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "License Expired ", 1));
                                ServerMateEventPublisher.shutdown();
                                SecurityManager.exit();
                                return;
                            }
                        }
                        if (!PersistentLicenseChecker.check()) {
                            SecurityManager.SECURITY_LOG.error("Security check failed: Kill thread timed out and license still not valid - " + PersistentLicenseManager.getInstance().toString());
                            ServerMateEventPublisher.shutdown();
                            SecurityManager.exit();
                        }
                        return;
                    }
                    catch (Exception ex) {
                        System.exit(666);
                        return;
                    }
                }
            });
            killThread.start();
            return true;
        }
        return false;
    }

    private static enum LicenseState {
        VALID,
        INVALID;

    }
}

