/*
 * Decompiled with CFR 0.152.
 */
package servermate.security;

import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.security.impl.LicenceExceptionHandler;
import ordermate.security.impl.SecurityManager;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublisher;
import servermate.events.ServerMateEventType;
import servermate.failover.FailoverManager;
import servermate.security.PersistentLicenseChecker;
import servermate.security.SMLicenceExceptionHandler;

public class ServermateSecurityManager {
    private static boolean started = false;
    private static Thread licenseCheckThread;
    private static final int SLEEP_TIME = 120000;

    private ServermateSecurityManager() {
    }

    public static synchronized void start() {
        if (!started) {
            FailoverManager.init();
            FailoverSetup setup = FailoverManager.getInstanceSetup();
            SecurityManager.SecurityMode secMode = SecurityManager.SecurityMode.Normal;
            Date failoverDate = null;
            if (setup.isSlave()) {
                secMode = setup.isActingMaster() ? SecurityManager.SecurityMode.ActingMaster : SecurityManager.SecurityMode.Slave;
                failoverDate = SecurityManager.SecurityMode.ActingMaster.equals((Object)secMode) ? setup.getActualFailoverDate() : null;
            }
            OrderMate.LOG.info("Starting security as " + secMode);
            SecurityManager.initialise((SecurityManager.SecurityMode)secMode, (Date)failoverDate, (LicenceExceptionHandler)new SMLicenceExceptionHandler());
            SecurityManager.getInstance().start();
            started = true;
            Runnable runnable = new Runnable(){
                final int RETRY = 15;
                int retryCount = 0;

                @Override
                public void run() {
                    OrderMate.LOG.info("License Check is " + PersistentLicenseChecker.check());
                    while (!PersistentLicenseChecker.check() && this.retryCount < 15) {
                        PersistentLicenseManager.getInstance().refreshCachedLicenses();
                        if (PersistentLicenseChecker.check()) {
                            this.retryCount = 0;
                            ServermateSecurityManager.sleepBeforeCheck();
                            continue;
                        }
                        ++this.retryCount;
                        int terminateMinutes = 2 * (15 - this.retryCount);
                        OrderMate.LOG.warn("Invalid License try " + (this.retryCount + 1) + " will terminate in " + terminateMinutes + " minutes");
                        ServermateSecurityManager.sendInvalidLicenseEventToClients(terminateMinutes);
                        ServermateSecurityManager.sleepBeforeCheck();
                    }
                    if (this.retryCount >= 15) {
                        ServermateSecurityManager.sendInvalidLicenseEventToClients(0);
                        SecurityManager.SECURITY_LOG.error("License retry count (15) was exceeded with invalid license : " + PersistentLicenseManager.getInstance().toString());
                        SecurityManager.exit();
                    }
                }
            };
            try {
                new Thread(runnable).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ServermateSecurityManager.startLicenseCheckThread();
    }

    private static void sleepBeforeCheck() {
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void sendInvalidLicenseEventToClients(int minutesLeft) {
        OrderMate.LOG.info("Sending License Expired Message to clients . . .");
        ServerMateEventPublisher.publishLocalEvent(new ServerMateEvent(ServerMateEventType.LICENSE_EXPIRED, "License Invalid", minutesLeft));
    }

    public static synchronized void startLicenseCheckThread() {
        if (!ServermateSecurityManager.isLicenseCheckThreadRunning()) {
            licenseCheckThread = PersistentLicenseChecker.startThread();
        }
    }

    public static synchronized boolean isLicenseCheckThreadRunning() {
        return licenseCheckThread != null && licenseCheckThread.isAlive();
    }
}

