/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.backup;

import au.com.ordermate.util.Pair;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.config.ConfigBackup;
import ordermate.services.backup.BackupProcess;

public class BackupService {
    private static BackupService instance;
    private final Semaphore lock = new Semaphore(1);

    public static synchronized BackupService getInstance() {
        if (instance == null) {
            instance = new BackupService();
        }
        return instance;
    }

    private BackupService() {
    }

    public boolean isRunning() {
        return this.lock.availablePermits() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runBackup(ConfigBackup backup) {
        if (!this.preCheck(backup)) {
            return false;
        }
        boolean success = true;
        try {
            BackupProcess process = new BackupProcess(backup);
            success = process.run();
            backup.save();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem with the backup process", (Throwable)ex);
        }
        finally {
            this.lock.release();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Boolean, String> performOperation(ConfigBackup backup, String operation) {
        if (!this.preCheck(backup)) {
            return Pair.make((Object)Boolean.FALSE, (Object)"Failed Precheck");
        }
        boolean success = true;
        String response = null;
        try {
            BackupProcess process = new BackupProcess(backup);
            Method method = BackupProcess.class.getMethod(operation, new Class[0]);
            boolean result = (Boolean)method.invoke((Object)process, new Object[0]);
            response = process.getResult();
            success = result;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem with the backup operation:" + operation, (Throwable)ex);
        }
        finally {
            this.lock.release();
        }
        return Pair.make((Object)success, (Object)response);
    }

    private boolean preCheck(ConfigBackup backup) {
        if (backup == null) {
            OrderMate.LOG.error("Cannot run the backup for a null configuration.");
            return false;
        }
        if (!backup.isEnabled()) {
            OrderMate.LOG.warn("Will not run backup, disabled");
            return false;
        }
        if (!this.lock.tryAcquire()) {
            OrderMate.LOG.warn("Cannot run backup, currently in progress.");
            return false;
        }
        return true;
    }
}

