/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.bevcon;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import org.apache.logging.log4j.Level;

public class BevConExporter {
    private static BevConExporter instance;
    private static final String TABLE_NAME = ".dbo.POSData";
    private static String BEV_CON_DATA;
    private static final String LAST_EXPORT = "BevCon LastExport";
    private String server;
    private String instanceName;
    private String user;
    private String pass;
    private String dbName;
    private int port;
    private Date lastExport = new Date();
    private Semaphore latch = new Semaphore(1);

    public static BevConExporter getInstance() {
        if (instance == null) {
            instance = new BevConExporter();
        }
        return instance;
    }

    private BevConExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() throws Exception {
        OrderMate.LOG.info("BevCon Integration started");
        this.prime();
        OrderMate.LOG.info("Primed to connect to '" + this.server + "' Instance '" + this.instanceName + "' as '" + this.user + "' on port '" + this.port + "' to '" + this.dbName + "' with password?" + !StringUtils.isEmpty((String)this.pass));
        OrderMate.LOG.info("DataBase Table = " + BEV_CON_DATA);
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean proceed = true;
        OrderMate.LOG.info("Testing connection...");
        try {
            con = this.createConnection();
            OrderMate.LOG.info("Connection established to BevCon, checking last export date");
            String tapQuery = "SELECT TOP 1 DateTimeofTrans FROM " + BEV_CON_DATA + " ORDER BY Sequence DESC";
            pstmt = con.prepareStatement(tapQuery);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.lastExport = rs.getTimestamp(1);
                OrderMate.LOG.info("Result set retrieved, current latest export is " + this.lastExport);
            } else {
                OrderMate.LOG.info("Result set retrieved, but no data. This might be the first one we export...");
            }
            this.closeResultSet(rs);
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        catch (Exception ex) {
            proceed = false;
            OrderMate.LOG.log(Level.ERROR, "Cannot read database information, we cannot proceed.", (Throwable)ex);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(pstmt);
            this.closeConnection(con);
        }
        return proceed;
    }

    private Connection createConnection() throws SQLServerException {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            String connectionUrl = "jdbc:sqlserver://" + this.server + ";databaseName=" + this.dbName + ";user=" + this.user + ";password=" + this.pass;
            Connection con = DriverManager.getConnection(connectionUrl);
            OrderMate.LOG.info("BevCon Connection established");
            return con;
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Couldn't hook up the other way", (Throwable)ex);
            SQLServerDataSource ds = new SQLServerDataSource();
            ds.setIntegratedSecurity(true);
            ds.setServerName(this.server);
            if (!StringUtils.isEmpty((String)this.instanceName)) {
                ds.setInstanceName(this.instanceName);
            }
            if (this.port > 0) {
                ds.setPortNumber(this.port);
            }
            if (!StringUtils.isEmpty((String)this.dbName)) {
                ds.setDatabaseName(this.dbName);
            }
            return ds.getConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performExport() {
        if (this.latch.tryAcquire()) {
            try {
                if (!this.isValid()) {
                    OrderMate.LOG.log(Level.WARN, "BevCon Latch acquired, but connection is not valid");
                    this.latch.release();
                    return false;
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "BevCon Latch acquired, but connection failed", (Throwable)ex);
                this.latch.release();
                return false;
            }
            OrderMate.LOG.log(Level.WARN, "BevCon Latch acquired, exporting SIQs since " + this.lastExport);
            ExperimentalFeature exp = ExperimentalFeature.find((String)LAST_EXPORT);
            if (exp == null) {
                exp = new ExperimentalFeature(LAST_EXPORT, "0");
                exp.save();
            }
            try {
                TradingDay lastDay = (TradingDay)PersistenceManager.getObject(TradingDay.class, (String)Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, this.lastExport, SQLDateType.DATE).toString());
                if (lastDay == null) {
                    lastDay = TradingDay.getCurrentTradingDay();
                }
                List siqs = PersistenceManager.getObjectList(SalesItemQuantity.class, (String)Query.select(SalesItemQuantity.class).greaterThanOrEqual(SalesItemQuantity.Properties.TRADING_DAY, (Object)lastDay).greaterThan(SalesItemQuantity.Properties.ID, (Object)Long.valueOf(exp.getValue())).orderBy(SalesItemQuantity.Properties.ID).toString());
                try {
                    Long lastId = this.examineQuantities(siqs);
                    if (lastId != null) {
                        exp.setValue(lastId.toString());
                        exp.save();
                    }
                }
                catch (SQLServerException ex) {
                    OrderMate.LOG.log(Level.ERROR, "Cannot examine the bevcon quantities, cannot guarantee the export", (Throwable)ex);
                    boolean bl = false;
                    this.latch.release();
                    OrderMate.LOG.info("Released BevCon Latch");
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.latch.release();
                OrderMate.LOG.info("Released BevCon Latch");
            }
        }
        OrderMate.LOG.log(Level.WARN, "BevCon Latch already taken, cannot export while already exporting");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long examineQuantities(List<SalesItemQuantity> siqs) throws SQLServerException {
        if (siqs.isEmpty()) {
            return null;
        }
        int inserted = 0;
        boolean updated = false;
        Long lastId = null;
        Connection con = null;
        PreparedStatement insert = null;
        ResultSet rs = null;
        try {
            con = this.createConnection();
            for (SalesItemQuantity siq : siqs) {
                SalesLineItem line = siq.getSalesLineItem();
                if (!(line instanceof SalesItem)) continue;
                if (insert == null) {
                    insert = con.prepareStatement("INSERT INTO " + BEV_CON_DATA + " (PLU, DateTimeofTrans, Qty, Premises, Location, Register) VALUES( ?, ?, ?, ?, ?, ?)");
                }
                insert.setLong(1, ((SalesComponent)((SalesItem)line).getComponentList().get(0)).getUnit().getID());
                insert.setTimestamp(2, new Timestamp(siq.getCreationTime().getTime()));
                insert.setBigDecimal(3, siq.getQuantity().getValue());
                insert.setLong(4, 1L);
                insert.setLong(5, siq.getLocation().getID());
                insert.setLong(6, siq.getTerminal().getID());
                if (insert.executeUpdate() == 1) {
                    ++inserted;
                    lastId = siq.getID();
                }
                this.closeResultSet(rs);
            }
            OrderMate.LOG.info("Updated BevCon SIQs " + siqs.size() + ". Inserted " + inserted);
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.ERROR, "Error while exporting sales item quantities", (Throwable)ex);
        }
        finally {
            this.closeResultSet(rs);
            this.closeStatement(insert);
            this.closeConnection(con);
        }
        return lastId;
    }

    private void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Cannot close off result set", (Throwable)ex);
            }
        }
    }

    private void closeStatement(PreparedStatement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Cannot close off Bevcon Statement", (Throwable)ex);
            }
        }
    }

    private void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Cannot close off bevcon connection", (Throwable)ex);
            }
        }
    }

    private void prime() {
        try {
            Config.readConfigData((String)"ServerMateConfig.ini");
            this.server = this.ifNull(Config.getStringValue((String)"BCServer"), "localhost");
            this.user = this.ifNull(Config.getStringValue((String)"BCUser"), "bevcon_test");
            this.pass = this.ifNull(Config.getDecryptedStringValue((String)"BCPass"), "bevconsol");
            this.port = Integer.valueOf(this.ifNull(Config.getStringValue((String)"BCPort"), "0"));
            this.dbName = this.ifNull(Config.getStringValue((String)"BCDBName"), "Bevcon");
            this.instanceName = Config.getStringValue((String)"BCInstance");
            BEV_CON_DATA = this.dbName + TABLE_NAME;
        }
        catch (IOException ex) {
            OrderMate.LOG.log(Level.ERROR, "Cannot read in Servermate config for BevCon", (Throwable)ex);
        }
    }

    private String ifNull(String check, String defaultValue) {
        if (StringUtils.isEmpty((String)check)) {
            return defaultValue;
        }
        return check;
    }
}

