/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.paypal;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.integration.jaxb.paypal.PayPalError;
import ordermate.integration.jaxb.paypal.PayPalLocation;
import ordermate.integration.jaxb.paypal.PayPalTab;
import ordermate.integration.paypal.PayPalComms;
import ordermate.integration.paypal.PayPalTool;
import ordermate.integration.paypal.remote.PayPalServiceRemote;
import ordermate.integration.paypal.remote.WebPaymentIntegrationQueries;
import servermate.services.paypal.UpdatePayPalTabTask;

public class PayPalService
extends UnicastRemoteObject
implements PayPalServiceRemote {
    private static final long DEFAULT_SLEEP = 52000L;
    private transient PayPalTool tool;
    private transient PayPalComms comms;
    private transient UpdatePayPalTabTask refreshTabsTask;
    private transient Timer timer;
    private static PayPalService service;
    private WebPaymentIntegration integration;
    private long interval;

    public static PayPalService getInstance() {
        return PayPalService.getInstance(WebPaymentIntegrationQueries.getPayPalIntegration());
    }

    public static PayPalService getInstance(WebPaymentIntegration integration) {
        if (service == null) {
            try {
                service = new PayPalService(integration);
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Error Initialising the PayPalService!", (Throwable)e);
            }
        }
        return service;
    }

    public PayPalService(WebPaymentIntegration integration) throws RemoteException {
        this.integration = integration;
        this.comms = new PayPalComms(integration);
        this.tool = new PayPalTool();
        this.refreshTabsTask = new UpdatePayPalTabTask(integration);
        this.startTimer();
    }

    public PayPalError changeLocationAvailability(WebPaymentLocation location, boolean open) throws RemoteException {
        location.setAvailable(open);
        String response = this.comms.postLocation(this.tool.makePayPalLocation(location));
        if (response == null) {
            PayPalError error = new PayPalError();
            error.setErrorType("Server could not be reached");
            return error;
        }
        if (response.contains("errorCode")) {
            return (PayPalError)this.tool.unmarshal(response, PayPalError.class);
        }
        PayPalLocation returnedLocation = (PayPalLocation)this.tool.unmarshal(response, PayPalLocation.class);
        if (returnedLocation == null) {
            return this.comms.getPayPalTool().createPayPalError("Error occured parsing in the PayPalLocation response!", "Error occured Parsing in the response : " + response);
        }
        if (returnedLocation != null && returnedLocation.getId() != null) {
            this.comms.getPayPalTool().applyToWebLocation(location, returnedLocation);
            location.saveChild();
        } else {
            OrderMate.LOG.error("Failed to change " + location + " to open=" + open);
        }
        this.integrationChanged();
        return this.comms.getPayPalTool().getSucesssfulPayPalError();
    }

    private void startTimer() {
        this.timer = new Timer();
        this.interval = this.getInterval();
        if (Config.isDebuging()) {
            OrderMate.LOG.info("startTimer refreshTabsTask interval: " + this.interval);
        }
        this.timer.scheduleAtFixedRate((TimerTask)this.refreshTabsTask, this.interval, this.interval);
    }

    private long getInterval() {
        Long intervalLong;
        List locations;
        if (this.integration != null && (locations = this.integration.getLocations()) != null && !locations.isEmpty() && (intervalLong = ((WebPaymentLocation)PersistenceManager.reacquire((PersistentObjectI)((PersistentObjectI)locations.get(0)))).getUpdateInterval()) != null) {
            return intervalLong;
        }
        return 52000L;
    }

    public WebPaymentIntegration getWebPaymentIntegration() {
        return service.getWebPaymentIntegration();
    }

    public void refresh() throws RemoteException {
        this.refreshTabsTask.run();
    }

    public List<Long> getCachedWebPaymentCustomerIds() throws RemoteException {
        return this.refreshTabsTask.getCachedWebPaymentCustomerIds();
    }

    public PayPalError trySyncLocation(WebPaymentLocation toSync) throws RemoteException {
        String response = this.comms.postLocation(this.tool.makePayPalLocation(toSync));
        if (response == null) {
            return this.comms.getPayPalTool().createPayPalError("Error occured receiving the PayPalLocation response!", "Error occured sending the response");
        }
        if (response.contains("errorCode")) {
            return (PayPalError)this.tool.unmarshal(response, PayPalError.class);
        }
        PayPalLocation returnedLocation = (PayPalLocation)this.tool.unmarshal(response, PayPalLocation.class);
        if (returnedLocation == null) {
            return this.comms.getPayPalTool().createPayPalError("Error occured parsing in the PayPalLocation response!", "Error occured Parsing in the response : " + response);
        }
        if ("deleted".equals(returnedLocation.getStatus())) {
            return this.comms.getPayPalTool().createPayPalError("That location has been deleted.", "The location " + returnedLocation.getId() + " has been deleted");
        }
        if (returnedLocation != null && returnedLocation.getId() != null) {
            this.comms.getPayPalTool().applyToWebLocation(toSync, returnedLocation);
            toSync.saveChild();
        }
        this.integrationChanged();
        return this.comms.getPayPalTool().getSucesssfulPayPalError();
    }

    public boolean syncLogo(WebPaymentLocation location, byte[] imageRawBytes) throws RemoteException {
        String response = this.comms.setLogo(this.tool.makePayPalLocation(location), imageRawBytes);
        if (response == null) {
            return false;
        }
        boolean toReturn = response.contains("201 Created");
        if (!toReturn) {
            OrderMate.LOG.info("Received unexpected response on uploading logo: " + response);
        }
        return toReturn;
    }

    public boolean tryDeleteLocation(WebPaymentLocation toDelete) {
        PayPalLocation deletedLocation = this.comms.deleteLocation(this.tool.makePayPalLocation(toDelete));
        boolean success = false;
        if (deletedLocation != null) {
            this.tool.applyToWebLocation(toDelete, deletedLocation);
            toDelete.saveChild();
            success = deletedLocation.getStatus().equals("deleted");
        }
        if (success) {
            this.integrationChanged();
        }
        return success;
    }

    public boolean tryDeleteAllLocations() throws RemoteException {
        List locations = this.comms.getLocations();
        if (locations == null) {
            return false;
        }
        for (PayPalLocation loc : locations) {
            this.comms.deleteLocation(loc);
        }
        locations = this.comms.getLocations();
        return locations != null && locations.isEmpty();
    }

    public WebPaymentCustomer retrieveWebCustomer(String locationId, String tabId) {
        WebPaymentCustomer customer = (WebPaymentCustomer)PersistenceManager.getObject(WebPaymentCustomer.class, (String)Query.select(WebPaymentCustomer.class).equals(WebPaymentCustomer.Properties.EXT_ID, (Object)tabId).toString());
        if (customer == null) {
            WebPaymentLocation location = null;
            if (locationId != null && !locationId.isEmpty()) {
                for (WebPaymentLocation nextLocation : this.integration.getLocations()) {
                    if (!locationId.equals(nextLocation.getExtId())) continue;
                    location = nextLocation;
                }
            }
            if (location == null && this.integration.getLocations().isEmpty()) {
                location = (WebPaymentLocation)this.integration.getLocations().get(0);
            }
            if (location != null) {
                PayPalTab tab = this.comms.getTab(location.getExtId(), tabId);
                if (tab != null) {
                    OrderMate.LOG.info("Found tab from paypal, making as a customer");
                    customer = this.comms.getPayPalTool().generateWebserviceIntegrationCustomer(tab, location);
                    if (customer != null) {
                        this.comms.getPayPalTool().applyTabToCustomer(tab, customer);
                        customer.save();
                    } else {
                        OrderMate.LOG.warn("Tab from paypal not correct, cannot make a webcustomer");
                    }
                } else {
                    OrderMate.LOG.warn("No PayPal tab was found for " + tabId);
                }
            } else {
                OrderMate.LOG.warn("Cannot retrieve a tab without a location for id " + locationId);
            }
        }
        return customer;
    }

    public boolean updateIntegration() throws RemoteException {
        if (this.integration != null) {
            this.integration = (WebPaymentIntegration)PersistenceManager.reacquire((PersistentObjectI)this.integration);
        } else {
            this.integration = WebPaymentIntegrationQueries.getPayPalIntegration();
            if (this.integration == null) {
                OrderMate.LOG.warn("No WebPaymentIntegration found to update - ending update call");
                return false;
            }
        }
        this.comms = new PayPalComms(this.integration);
        this.integrationChanged();
        return true;
    }

    private void integrationChanged() {
        this.refreshTabsTask.integrationChanged();
        if (this.interval != this.getInterval()) {
            this.timer.cancel();
            this.refreshTabsTask = new UpdatePayPalTabTask(this.integration);
            this.startTimer();
        }
    }
}

