/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.paypal;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.image.ImageHelper;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentCustomer;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.sales.Customer;
import ordermate.integration.jaxb.paypal.PayPalTab;
import ordermate.integration.paypal.PayPalComms;
import ordermate.integration.paypal.remote.WebPaymentIntegrationQueries;
import ordermate.integration.webservice.RestHelper;

class UpdatePayPalTabTask
extends TimerTask {
    private final Semaphore talkingStick;
    private PayPalComms comms;
    private WebPaymentIntegration integration;
    private Map<String, WebPaymentCustomer> webCustomerCache;
    private AtomicReference<String> modifiedSinceTime = new AtomicReference<Object>(null);

    UpdatePayPalTabTask(WebPaymentIntegration integration) {
        this.integration = integration;
        this.talkingStick = new Semaphore(1);
        this.comms = new PayPalComms(integration);
        this.webCustomerCache = new HashMap<String, WebPaymentCustomer>();
        for (WebPaymentCustomer customer : PersistenceManager.getObjectList(WebPaymentCustomer.class, (String)Query.select(WebPaymentCustomer.class).toString())) {
            this.addToCache(customer);
        }
    }

    @Override
    public void run() {
        if (this.talkingStick.tryAcquire()) {
            try {
                this.checkForUpdatedCustomersForLocations();
                this.removeExpiredCustomers();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Unexpected PayPalTabTask exception", (Throwable)e);
            }
            finally {
                this.talkingStick.release();
            }
        } else {
            OrderMate.LOG.warn("Still updating the paypal tabs from last time. Refresh skipped");
        }
    }

    private void checkForUpdatedCustomersForLocations() {
        for (WebPaymentLocation location : this.integration.getLocations()) {
            if (location.getExtId() == null || location.getExtId().trim().isEmpty()) {
                OrderMate.LOG.warn("Cannot update paypal tabs for location without an external ID");
                continue;
            }
            OrderMate.LOG.info("Updating PayPalTabs for " + location.getInternalLabel());
            List updatedTabs = this.comms.getCurrentTabs(location.getExtId(), this.modifiedSinceTime);
            if (Config.isDebuging()) {
                StringBuilder SB = new StringBuilder("Tabs returned:\r\n");
                if (updatedTabs == null || updatedTabs.isEmpty()) {
                    SB.append("None");
                } else {
                    for (PayPalTab tab : updatedTabs) {
                        SB.append("#").append(tab.getCustomerId()).append(" ").append(tab.getCustomerName()).append(" ").append(tab.getStatus()).append(" ").append(tab.getUpdateDate()).append("\r\n");
                    }
                }
                OrderMate.LOG.info(SB.toString());
            }
            if (updatedTabs == null) continue;
            HashSet<WebPaymentCustomer> customers = new HashSet<WebPaymentCustomer>(this.webCustomerCache.values());
            for (PayPalTab tab : updatedTabs) {
                this.processTab(tab, location, customers);
            }
            for (WebPaymentCustomer cust : customers) {
                cust.setCheckedIn(false);
                cust.save();
            }
        }
    }

    private void removeExpiredCustomers() {
        for (WebPaymentCustomer customer : new HashSet<WebPaymentCustomer>(this.webCustomerCache.values())) {
            if (!customer.isExpired()) continue;
            this.clearFromCache(customer.getExtId());
            customer.delete();
        }
    }

    private void processTab(PayPalTab tab, WebPaymentLocation location, Set<WebPaymentCustomer> customers) {
        WebPaymentCustomer webCustomer = this.getFromCache(tab.getId());
        if (webCustomer == null) {
            webCustomer = (WebPaymentCustomer)PersistenceManager.getObject(WebPaymentCustomer.class, (String)Query.select(WebPaymentCustomer.class).equals(WebPaymentCustomer.Properties.EXT_ID, (Object)tab.getId()).equals(WebPaymentCustomer.Properties.LOCATION, (Object)location).toString());
        }
        if (webCustomer == null) {
            webCustomer = this.comms.getPayPalTool().generateWebserviceIntegrationCustomer(tab, location);
        }
        if (webCustomer != null) {
            this.comms.getPayPalTool().applyTabToCustomer(tab, webCustomer);
            webCustomer.save();
            this.addToCache(webCustomer);
            customers.remove(webCustomer);
            this.updateImageData(webCustomer);
            this.performCustomerWebCustomerMatchingStrategy(webCustomer);
        }
    }

    void performCustomerWebCustomerMatchingStrategy(WebPaymentCustomer webCustomer) {
        String name = webCustomer.getLabel();
        String[] split = name.split(" ");
        String first = split[0];
        String last = split[1];
        ObjectQuery query = Query.select(Customer.class).startsWith(Customer.Properties.FIRST_NAME, first).startsWith(Customer.Properties.LAST_NAME, last).orderBy(Customer.Properties.FIRST_NAME).active(Customer.class).distinct();
        List potentialMatches = PersistenceManager.getObjectList(Customer.class, (String)query.toString(), null);
        if (potentialMatches.size() == 1) {
            Customer customer = (Customer)potentialMatches.get(0);
            CustomerImageStrategyFactory customerStrategies = new CustomerImageStrategyFactory();
            if (customerStrategies.getStrategyCondition(CustomerImageStrategy.ALWAYS_UPDATE).objectMeetsConditions(customer)) {
                customer.setImage(webCustomer.getImage());
                customer.save();
            }
        }
    }

    private void addToCache(WebPaymentCustomer webCustomer) {
        this.webCustomerCache.put(webCustomer.getExtId(), webCustomer);
    }

    private WebPaymentCustomer getFromCache(String extId) {
        return this.webCustomerCache.get(extId);
    }

    private void clearFromCache(String extId) {
        this.webCustomerCache.remove(extId);
    }

    private void updateImageData(WebPaymentCustomer customer) {
        ImageHelper helper;
        BufferedImage buf;
        String url;
        ConfigSmallImage image = customer.getImage();
        if (image.getByteLength() == 0L && (url = customer.getImageUrl()) != null && !url.isEmpty() && (buf = this.retrieveImage(url, helper = new ImageHelper())) != null) {
            image.setImage((Image)buf);
            image.save();
        }
    }

    private BufferedImage retrieveImage(String url, ImageHelper helper) {
        WebResource resource = new RestHelper().getResource(url, Integer.valueOf(5000), Integer.valueOf(10000));
        byte[] response = null;
        try {
            response = (byte[])resource.get(byte[].class);
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.error("Cannot retrieve data for ", (Throwable)ex);
        }
        if (response == null || response.length == 0) {
            return null;
        }
        BufferedImage image = null;
        try {
            image = helper.readInFromBytes(response);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot read in image for customer", (Throwable)ex);
        }
        return image;
    }

    public synchronized List<Long> getCachedWebPaymentCustomerIds() {
        ArrayList<Long> idsToReturn = new ArrayList<Long>();
        for (WebPaymentCustomer cust : this.webCustomerCache.values()) {
            if (!cust.isCheckedIn()) continue;
            idsToReturn.add(cust.getID());
        }
        return idsToReturn;
    }

    public synchronized void integrationChanged() {
        try {
            if (this.talkingStick.tryAcquire(30L, TimeUnit.SECONDS)) {
                if (this.integration != null) {
                    this.integration = (WebPaymentIntegration)PersistenceManager.reacquire((PersistentObjectI)this.integration);
                } else {
                    this.integration = WebPaymentIntegrationQueries.getPayPalIntegration();
                    if (this.integration == null) {
                        OrderMate.LOG.warn("No WebPaymentIntegration found to update - integrationChanged call terminated");
                        return;
                    }
                }
                this.comms = new PayPalComms(this.integration);
                OrderMate.LOG.info("integration updated for UpdatePayPalTabTask");
                this.talkingStick.release();
            } else {
                OrderMate.LOG.warn("Still updating the paypal tabs from last time. integration reacquire skipped");
            }
        }
        catch (InterruptedException e) {
            OrderMate.LOG.error("Could not acquire the semaphor for UpdatePayPalTabTask", (Throwable)e);
        }
    }

    private static interface ObjectStateCondition<T> {
        public boolean objectMeetsConditions(T var1);
    }

    private static class CustomerImageStrategyFactory {
        private Map<CustomerImageStrategy, ObjectStateCondition<Customer>> map = new HashMap<CustomerImageStrategy, ObjectStateCondition<Customer>>(){
            {
                this.put(CustomerImageStrategy.SET_ONCE, new ObjectStateCondition<Customer>(){

                    @Override
                    public boolean objectMeetsConditions(Customer object) {
                        return object.getImage() == null;
                    }
                });
                this.put(CustomerImageStrategy.ALWAYS_UPDATE, new ObjectStateCondition<Customer>(){

                    @Override
                    public boolean objectMeetsConditions(Customer object) {
                        return true;
                    }
                });
            }
        };

        private CustomerImageStrategyFactory() {
        }

        public ObjectStateCondition<Customer> getStrategyCondition(CustomerImageStrategy strategy) {
            return this.map.get((Object)strategy);
        }
    }

    private static enum CustomerImageStrategy {
        SET_ONCE,
        ALWAYS_UPDATE;

    }
}

