/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.timedifference;

import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.integration.webservice.RestHelper;

public class TimeDifferenceWorker
implements Runnable {
    private static final String RESOURCE_LOCATION = "synchronize/timeDifference";
    private boolean finished = false;
    private long checkTime;

    public TimeDifferenceWorker(long timeBetweenChecks) {
        this.checkTime = timeBetweenChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RestHelper helper = new RestHelper();
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation()).append(RESOURCE_LOCATION);
        String url = SB.toString();
        while (!this.finished) {
            WebResource resource = helper.getResource(url);
            if (resource != null) {
                resource = helper.addBasicAuth(resource, "" + StoreGroup.getInstance().getStoreId(), StoreGroup.getInstance().getStoreName());
                resource = helper.addParameter(resource, "localTime", "" + System.currentTimeMillis());
                try {
                    String delta = helper.getText(resource);
                    long value = Long.valueOf(delta);
                    HOConfig config = HOConfig.getInstance();
                    config.setTimeDifference(value);
                    OrderMate.LOG.info("Returned value from TimeDifference is : " + value);
                    config.save();
                }
                catch (NumberFormatException ex) {
                    OrderMate.LOG.warn("Returned value from TimeDifference is bad: ", (Throwable)ex);
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Could not retrieve time difference:", (Throwable)ex);
                }
            } else {
                OrderMate.LOG.info("Cannot find TimeDifference resource for : " + url);
            }
            TimeDifferenceWorker timeDifferenceWorker = this;
            synchronized (timeDifferenceWorker) {
                try {
                    this.wait(this.checkTime);
                }
                catch (InterruptedException ex) {
                    this.finished = true;
                }
            }
        }
    }

    public void closeOff() {
        this.finished = true;
        this.notifyAll();
    }
}

