/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher;

import au.com.ordermate.hive.voucher.HiveRequestBuilderException;
import au.com.ordermate.hive.voucher.HiveVoucherRequestBuilder;
import au.com.ordermate.hive.xmlintegration.voucher.HiveVoucher;
import au.com.ordermate.hive.xmlintegration.voucher.HiveVoucherRequest;
import au.com.ordermate.hive.xmlintegration.voucher.HiveVoucherResponse;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import hive.VoucherAdministratorResource;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherAuthority;
import ordermate.database.finance.giftvoucher.VoucherError;
import ordermate.database.finance.giftvoucher.VoucherRequest;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.queries.finance.voucher.VoucherQueries;
import ordermate.database.users.User;
import ordermate.jaxb.exporter.XMLHelper;
import servermate.services.voucher.HiveVoucherMinion;

public class HiveVoucherAuthority
implements VoucherAuthority {
    private final GiftVoucherConfiguration config;
    private static final String VOUCHER_PATH = "voucher/";
    private static final String GET = "getVoucher";
    private static final String RESYNC = "resyncVoucher";
    private static final String CREATE = "createVoucher";
    private static final String TOPUP = "topupVoucher";
    private static final String REDEEM = "redeemVoucher";
    private static final String CONFIRM = "confirmTransaction";
    private static final String CANCEL = "cancelTransaction";
    private static final String REVERSE = "reverseTransaction";
    private String barcodePrefix;
    private Map<String, String> pathMap = new HashMap<String, String>();

    protected HiveVoucherAuthority(GiftVoucherConfiguration yourConfig) {
        this.primePathMap();
        this.config = yourConfig;
        if (StringUtils.isEmpty((String)this.config.getPrefix()) && this.config.getPrefix().length() > 1) {
            this.barcodePrefix = this.config.getPrefix().substring(0, 2);
        }
    }

    public VoucherResponse getVoucher(VoucherRequest request) {
        VoucherResponse response;
        GiftVoucher voucher = VoucherQueries.getVoucherForId((String)request.getUUID());
        if (voucher != null) {
            VoucherResponse response2 = new VoucherResponse(request, true, null);
            response2.setVoucher(voucher);
            return response2;
        }
        try {
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).buildForQueryVoucher();
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, GET);
            response = new VoucherResponse(request, true, null);
            if (hiveResponse != null) {
                if (Boolean.TRUE.equals(hiveResponse.isSuccess())) {
                    voucher = this.fetchVoucherFromResponse(hiveResponse);
                    response.setVoucher(voucher);
                    response.setDescription(hiveResponse.getDescription());
                } else {
                    OrderMate.LOG.warn("Cannot get voucher: " + hiveResponse.getDescription());
                }
                response.setDescription(hiveResponse.getDescription());
            } else {
                response.setError(VoucherError.SERVER_ERROR);
                response.setDescription("The Hive server returned an invalid result.");
            }
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("get a voucher", request, (Exception)((Object)ex));
        }
        return response;
    }

    public VoucherResponse resyncVoucher(VoucherRequest request) {
        VoucherResponse response;
        try {
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).buildForQueryVoucher();
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, RESYNC);
            response = new VoucherResponse(request, Boolean.TRUE.equals(hiveResponse.isSuccess()), null);
            if (response.isApproved()) {
                GiftVoucher voucher = this.fetchVoucherFromResponse(hiveResponse);
                response.setVoucher(voucher);
                OrderMate.LOG.info("Successfully resynchronized voucher:" + voucher + " " + voucher.getCachedValue());
            } else {
                OrderMate.LOG.warn("Cannot resynchronize voucher: " + response.getDescription());
            }
            response.setDescription(hiveResponse.getDescription());
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("resync a voucher", request, (Exception)((Object)ex));
        }
        return response;
    }

    public VoucherResponse createVoucher(VoucherRequest request) {
        VoucherResponse response;
        try {
            String uuid = this.config.isAutoGen() ? HiveVoucherRequestBuilder.makeProtoUUID((String)this.config.getPrefix(), (int)this.config.getUuidLength()) : request.getUUID();
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(uuid).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).buildForQueryVoucher();
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, CREATE);
            response = new VoucherResponse(request, Boolean.TRUE.equals(hiveResponse.isSuccess()), null);
            if (response.isApproved()) {
                GiftVoucher voucher = this.fetchVoucherFromResponse(hiveResponse);
                response.setVoucher(voucher);
            } else {
                response = this.createInvalidResponse("create a voucher", request, null);
                response.setError(this.config.isAutoGen() ? VoucherError.CANNOT_GENERATE : VoucherError.CANNOT_CREATE);
            }
            response.setDescription(hiveResponse.getDescription());
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("create a voucher", request, (Exception)((Object)ex));
        }
        return response;
    }

    public VoucherResponse topupVoucher(VoucherRequest request) {
        VoucherResponse response;
        GiftVoucherTransaction txn = request.getTransaction();
        if (txn.isAuthorised()) {
            OrderMate.LOG.error("Cannot re-request a previously authorised transaction " + txn.getAuthId());
            return this.createInvalidResponse("topup a voucher", request, null);
        }
        if (!txn.isActive()) {
            OrderMate.LOG.error("Cannot request a deleted transaction " + txn.getID());
            return this.createInvalidResponse("topup a voucher", request, null);
        }
        XMLGregorianCalendar expiry = null;
        if (txn.getExpiryDate() != null) {
            expiry = XMLHelper.getDateType((Date)txn.getExpiryDate());
        }
        try {
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).setAmount(txn.getAmount().toBigDecimal()).setExpiry(expiry).buildForTopup();
            hiveRequest.setUserId(request.getTransaction().getUserId());
            hiveRequest.setTerminalId(request.getTransaction().getTerminalId());
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, TOPUP);
            response = this.authoriseTxn(TOPUP, request, hiveResponse, txn);
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("topup a voucher", request, (Exception)((Object)ex));
        }
        return response;
    }

    public VoucherResponse redeemVoucher(VoucherRequest request) {
        VoucherResponse response;
        GiftVoucherTransaction txn = request.getTransaction();
        if (!txn.isActive()) {
            OrderMate.LOG.error("Cannot re-request a previously authorised transaction " + txn.getID());
            return this.createInvalidResponse("redeem a voucher", request, null);
        }
        if (txn.isConfirmed()) {
            OrderMate.LOG.error("Cannot re-request a previously confirmed transaction " + txn.getAuthId());
            return this.createInvalidResponse("redeem a voucher", request, null);
        }
        if (txn.isAuthorised()) {
            OrderMate.LOG.warn("This redemption has already been authorised " + txn.getAuthId());
            return new VoucherResponse(request, true, txn.getAuthId());
        }
        try {
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).setAmount(txn.getAmount().toBigDecimal().abs()).buildForRedeem();
            hiveRequest.setUserId(request.getTransaction().getUserId());
            hiveRequest.setTerminalId(request.getTransaction().getTerminalId());
            hiveRequest.setSalesId(request.getTransaction().getAccount().getID().toString());
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, REDEEM);
            response = this.authoriseTxn(REDEEM, request, hiveResponse, txn);
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("redeem a voucher", request, (Exception)((Object)ex));
        }
        return response;
    }

    private VoucherResponse authoriseTxn(String method, VoucherRequest request, HiveVoucherResponse hiveResponse, GiftVoucherTransaction txn) {
        VoucherResponse response;
        GiftVoucher voucher = this.fetchVoucherFromResponse(hiveResponse);
        if (Boolean.TRUE.equals(hiveResponse.isSuccess())) {
            Long auth = hiveResponse.getAuthId();
            if (auth != null) {
                if (hiveResponse.getAmount() != null) {
                    txn.setAmount(new Price((Number)hiveResponse.getAmount(), 0.01));
                }
                txn.authorise(auth.toString());
                PersistenceManager.saveChild((PersistentObject)txn);
                response = new VoucherResponse(request, true, txn.getAuthId());
                response.setTransactionReference(hiveResponse.getTransactionReference());
                response.setTxn(txn);
            } else {
                OrderMate.LOG.warn("Cannot " + method + " voucher, no authId came through with response. " + hiveResponse.getDescription());
                response = new VoucherResponse(request, false, null);
                response.setTxn(txn);
                response.setError(VoucherError.SERVER_ERROR);
            }
            response.setDescription(hiveResponse.getDescription());
        } else {
            OrderMate.LOG.warn("Cannot authorise " + method + " voucher transaction:" + hiveResponse.getDescription());
            response = new VoucherResponse(request, false, null);
            response.setDescription(hiveResponse.getDescription());
            response.setError(VoucherError.NOT_AUTHORISED);
        }
        response.setVoucher(voucher != null ? voucher : txn.getGiftVoucher());
        return response;
    }

    public VoucherResponse confirmTransaction(VoucherRequest request) {
        VoucherResponse response = this.checkTxnOperation(CONFIRM, request);
        if (response != null) {
            return response;
        }
        int count = 0;
        while (!(response != null && response.isApproved() || count >= 5)) {
            if (count > 0) {
                try {
                    OrderMate.LOG.info("Sleeping a couple of seconds before retrying confirmation request");
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++count;
            try {
                HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).buildForRedeem();
                hiveRequest.setAuthId(Long.valueOf(request.getTransaction().getAuthId()));
                hiveRequest.setConfirmationId(String.valueOf(request.getTransaction().getID()));
                HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, CONFIRM);
                if (Boolean.TRUE.equals(hiveResponse.isSuccess())) {
                    response = new VoucherResponse(request, true, null);
                    GiftVoucherTransaction txn = request.getTransaction();
                    txn.confirm();
                    PersistenceManager.saveChild((PersistentObject)txn);
                    response.setTxn(txn);
                    GiftVoucher voucher = this.fetchVoucherFromResponse(hiveResponse);
                    if (voucher != null) {
                        request.getTransaction().getGiftVoucher().setCachedValue(voucher.getCachedValue());
                    }
                    OrderMate.LOG.info("Voucher Transaction has been confirmed " + txn.getID());
                } else {
                    OrderMate.LOG.warn("Cannot confirm voucher transaction:" + hiveResponse.getDescription());
                    response = new VoucherResponse(request, false, null);
                    response.setError(VoucherError.CANNOT_CONFIRM);
                }
                response.setDescription(hiveResponse.getDescription());
            }
            catch (HiveRequestBuilderException ex) {
                response = this.createInvalidResponse("confirm a voucher transaction", request, (Exception)((Object)ex));
                response.setError(VoucherError.CANNOT_CONFIRM);
            }
        }
        response.setTxn(request.getTransaction());
        return response;
    }

    public VoucherResponse cancelTransaction(VoucherRequest request) {
        VoucherResponse response = this.checkTxnOperation(CANCEL, request);
        if (response != null) {
            return response;
        }
        try {
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).buildForRedeem();
            hiveRequest.setAuthId(Long.valueOf(request.getTransaction().getAuthId()));
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, CANCEL);
            if (Boolean.TRUE.equals(hiveResponse.isSuccess())) {
                response = new VoucherResponse(request, true, null);
                GiftVoucherTransaction txn = request.getTransaction();
                PersistenceManager.reacquire((PersistentObjectI)txn);
                txn.deleteChild();
                response.setTxn(txn);
            } else {
                OrderMate.LOG.warn("Cannot cancel voucher transaction:" + hiveResponse.getDescription());
                response = new VoucherResponse(request, false, null);
                response.setDescription(hiveResponse.getDescription());
                response.setError(VoucherError.NOT_AUTHORISED);
            }
            response.setDescription(hiveResponse.getDescription());
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("cancel a voucher transaction", request, (Exception)((Object)ex));
        }
        return response;
    }

    public VoucherResponse reverseTransaction(VoucherRequest request) {
        VoucherResponse response = this.checkTxnOperation(REVERSE, request);
        if (response != null) {
            return response;
        }
        try {
            GiftVoucherTransaction txnInRequest = request.getTransaction();
            HiveVoucherRequest hiveRequest = new HiveVoucherRequestBuilder().setUniqueId(request.getUUID()).setRBStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId())).setAmount(txnInRequest.getAmount().toBigDecimal().abs()).setAuthID(Long.valueOf(txnInRequest.getAuthId())).setConfirmationID(String.valueOf(txnInRequest.getID())).buildForRedeem();
            hiveRequest.setUserId(txnInRequest.getUserId());
            hiveRequest.setTerminalId(txnInRequest.getTerminalId());
            HiveVoucherResponse hiveResponse = this.doRequest(hiveRequest, REVERSE);
            if (Boolean.TRUE.equals(hiveResponse.isSuccess())) {
                GiftVoucherTransaction reversalTxn = new GiftVoucherTransaction(txnInRequest.getAmount().negate(), txnInRequest.getGiftVoucher(), null, null, txnInRequest.getAccount(), new EventContext(Terminal.getLocalHost(), User.getSystemUser()));
                reversalTxn.setExpiryDate(new Date());
                reversalTxn.setExpiryTime(new Date());
                reversalTxn.setReversedVoucherTransaction(txnInRequest);
                response = this.authoriseTxn(REVERSE, request, hiveResponse, reversalTxn);
            } else {
                OrderMate.LOG.warn("Cannot reverse voucher transaction:" + hiveResponse.getDescription());
                response = new VoucherResponse(request, false, null);
                response.setDescription(hiveResponse.getDescription());
                response.setError(VoucherError.NOT_AUTHORISED);
            }
            response.setDescription(hiveResponse.getDescription());
        }
        catch (HiveRequestBuilderException ex) {
            response = this.createInvalidResponse("reverse a voucher transaction", request, (Exception)((Object)ex));
        }
        return response;
    }

    private VoucherResponse checkTxnOperation(String action, VoucherRequest request) {
        GiftVoucherTransaction txn = request.getTransaction();
        if (!txn.isActive()) {
            OrderMate.LOG.warn("The voucher transaction to " + action + " is not active: " + txn.getID());
            return this.createInvalidResponse("confirm transaction", request, null);
        }
        if (!txn.isAuthorised()) {
            OrderMate.LOG.warn("The voucher transaction to " + action + " has not been authorised: " + txn.getID());
            return this.createInvalidResponse("confirm transaction", request, null);
        }
        if (action.equals(REVERSE)) {
            if (txn.isReversal()) {
                OrderMate.LOG.warn("The voucher transaction to " + action + " is a reversal: " + txn.getID());
                return this.createInvalidResponse("reverse transaction", request, null);
            }
            if (txn.isReversed()) {
                OrderMate.LOG.warn("The voucher transaction to " + action + " has been already reversed: " + txn.getID());
                return this.createInvalidResponse("reverse transaction", request, null);
            }
            if (!txn.isConfirmed()) {
                OrderMate.LOG.warn("The voucher transaction to " + action + " has not been confirmed: " + txn.getID());
                return this.createInvalidResponse("reverse transaction", request, null);
            }
        } else if (txn.isConfirmed()) {
            OrderMate.LOG.warn("The voucher transaction to " + action + " has already been confirmed: " + txn.getID());
            return this.createInvalidResponse("confirm transaction", request, null);
        }
        return null;
    }

    public boolean isHandled(String UUID) {
        String toTest;
        if (UUID == null || UUID.isEmpty()) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.config.getPrefix())) {
            OrderMate.LOG.info("Empty Prefix, testing if it's mine");
            if (UUID.length() >= this.config.getUuidLength()) {
                return true;
            }
        }
        if (!(toTest = UUID.trim()).startsWith(this.config.getPrefix())) {
            return false;
        }
        return toTest.length() == this.config.getUuidLength();
    }

    public Integer getVoucherDefaultExpiryPeriod() {
        return this.config.getDefaultExpiryPeriod();
    }

    public GiftVoucherConfiguration getConfiguration() {
        return this.config;
    }

    private void primePathMap() {
        this.findPath(GET);
        this.findPath(RESYNC);
        this.findPath(CREATE);
        this.findPath(TOPUP);
        this.findPath(REDEEM);
        this.findPath(REVERSE);
        this.findPath(CONFIRM);
        this.findPath(CANCEL);
    }

    private VoucherResponse createInvalidResponse(String verb, VoucherRequest request, Exception ex) {
        OrderMate.LOG.error("Cannot " + verb + ", request invalid", (Throwable)ex);
        VoucherResponse response = new VoucherResponse(request, false, null);
        response.setDescription("Cannot " + verb);
        response.setError(VoucherError.REQUEST_INVALID);
        return response;
    }

    protected void findPath(String path) {
        try {
            Method[] methods;
            for (Method method : methods = VoucherAdministratorResource.class.getMethods()) {
                if (!path.equals(method.getName())) continue;
                String value = method.getAnnotation(Path.class).value();
                this.pathMap.put(path, value);
                OrderMate.LOG.info("Hive Voucher " + path + " " + value);
                break;
            }
        }
        catch (SecurityException ex) {
            OrderMate.LOG.error("Cannot get voucher resource path: for " + path, (Throwable)ex);
        }
    }

    private HiveVoucherResponse doRequest(HiveVoucherRequest hiveRequest, String requestType) {
        WebResource.Builder resource = new HiveVoucherMinion().setupResource(this.config, VOUCHER_PATH + this.pathMap.get(requestType), new Pair[0]);
        ClientResponse response = null;
        try {
            response = (ClientResponse)((WebResource.Builder)resource.accept(new String[]{"application/xml"})).post(ClientResponse.class, (Object)hiveRequest);
            if (response.getStatus() / 100 == 2) {
                return (HiveVoucherResponse)response.getEntity(HiveVoucherResponse.class);
            }
            String output = (String)response.getEntity(String.class);
            OrderMate.LOG.error("Error with Hive: " + resource.toString() + "\r\n" + output);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot contact Hive on :" + resource.toString(), (Throwable)ex);
        }
        HiveVoucherResponse hiveResponse = new HiveVoucherResponse();
        hiveResponse.setCommand(requestType);
        hiveResponse.setSuccess(Boolean.FALSE);
        hiveResponse.setTimestamp(System.currentTimeMillis());
        hiveResponse.setDescription("There was an issue contacting the server, please try again. If the error persists, please contact OrderMate technical support.");
        return hiveResponse;
    }

    private GiftVoucher fetchVoucherFromResponse(HiveVoucherResponse hiveResponse) {
        List vouchers = hiveResponse.getVouchers();
        GiftVoucher voucher = null;
        if (vouchers != null && vouchers.size() > 0) {
            HiveVoucher hiveVoucher = (HiveVoucher)vouchers.get(0);
            voucher = VoucherQueries.getVoucherForId((String)hiveVoucher.getUniqueId());
            if (voucher == null) {
                voucher = new GiftVoucher(hiveVoucher.getUniqueId());
            }
            voucher.setCachedValue(new Price((Number)hiveVoucher.getValue(), 0.01));
            voucher.save();
        }
        return voucher;
    }

    private HiveVoucher fetchHiveVoucherFromResponse(HiveVoucherResponse hiveResponse) {
        List vouchers = hiveResponse.getVouchers();
        HiveVoucher hiveVoucher = null;
        if (vouchers != null && vouchers.size() > 0) {
            hiveVoucher = (HiveVoucher)vouchers.get(0);
        }
        return hiveVoucher;
    }

    public String toString() {
        return "Hive-" + this.getConfiguration().getLabel();
    }

    protected VoucherResponse fail(VoucherRequest request, VoucherError error) {
        VoucherResponse response = new VoucherResponse(request, false, null);
        response.setError(error);
        response.setVoucher(request.getVoucher());
        response.setTxn(request.getTransaction());
        return response;
    }
}

