/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher;

import au.com.ordermate.hive.voucher.HiveRequestBuilderException;
import au.com.ordermate.hive.voucher.HiveVoucherRequestBuilder;
import au.com.ordermate.hive.xmlintegration.voucher.HiveVoucherRequest;
import au.com.ordermate.hive.xmlintegration.voucher.HiveVoucherResponse;
import au.com.ordermate.hive.xmlintegration.voucher.HiveVoucherScheme;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.integration.webservice.WebserviceIntegrationType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.nudge.NudgeHelper;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.apache.commons.codec.binary.Base64;

class HiveVoucherMinion {
    private static final String HIVE_URL = "https://hive.ordermatecentral.com:8181/HiveBack/hive/";
    private static final String SCHEMES = "voucher/getschemes";
    private Integer NON_HIVE_TIMEOUT = 65000;
    private Integer TIMEOUT = 15000;

    HiveVoucherMinion() {
    }

    private String getBaseURL() {
        CloudBackConfig config = CloudBackConfig.getCloudBackConfig((CloudServerType)CloudServerType.Hive);
        if (config == null) {
            config = new CloudBackConfig(CloudServerType.Hive);
            WebserviceIntegrationConfig web = config.getWebConfig();
            ExperimentalFeature feature = ExperimentalFeature.find((String)"Hive Location");
            if (feature != null) {
                web.setUrl(feature.getStringValue(HIVE_URL));
            } else {
                web.setUrl(HIVE_URL);
            }
            config.setEnabled(true);
            config.save();
        }
        return config.getWebConfig().getUrl();
    }

    final WebResource.Builder setupResource(GiftVoucherConfiguration config, String path, Pair ... queryParams) {
        RestHelper rest = new RestHelper();
        String destination = null;
        destination = config == null || config.getWebConfig() == null || config.getWebConfig().getUrl() == null ? this.getBaseURL() + path : config.getWebConfig().getUrl() + path;
        OrderMate.LOG.info("Hive calling to " + destination);
        Integer timeout = this.TIMEOUT;
        if (config != null && StringUtils.isEmpty((String)config.getPrefix())) {
            timeout = this.NON_HIVE_TIMEOUT;
        }
        WebResource resource = destination.startsWith("https") ? rest.getSSLWebResource(destination, (X509TrustManager)((Object)new HiveTrustManager()), timeout, timeout, "TLSv1.2") : rest.getResource(destination, timeout, timeout);
        if (config != null) {
            resource = rest.addBasicAuth(resource, config.getWebConfig().getUsername(), config.getWebConfig().getPassword());
        }
        for (Pair pair : queryParams) {
            resource = rest.addParameter(resource, String.valueOf(pair.key), String.valueOf(pair.value));
        }
        return resource.header("Hive-Agent", (Object)new String(Base64.encodeBase64((byte[])"Agent-Gold".getBytes())));
    }

    List<HiveVoucherScheme> pullSchemesFromHive() {
        String endpoint = SCHEMES;
        WebResource.Builder resource = this.setupResource(null, endpoint, new Pair[0]);
        HiveVoucherResponse response = null;
        try {
            HiveVoucherRequest request = new HiveVoucherRequestBuilder().setRBStoreId(Long.valueOf(this.getRedBackId())).buildForSchemeRequest();
            response = (HiveVoucherResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.accept(new String[]{"application/xml"})).type("application/xml")).entity((Object)request)).post(HiveVoucherResponse.class);
        }
        catch (HiveRequestBuilderException e) {
            OrderMate.LOG.error("Failed to build voucher request for getschemes!", (Throwable)e);
        }
        catch (Exception e) {
            OrderMate.LOG.error("No response from Hive while attempting to update schemes. Hive voucher schemes may be out of date!", (Throwable)e);
        }
        if (response != null) {
            return response.getSchemes();
        }
        return Collections.emptyList();
    }

    public void persistNewSchemes() {
        this.persistNewSchemes(this.pullSchemesFromHive());
    }

    protected void persistNewSchemes(List<HiveVoucherScheme> schemes) {
        for (HiveVoucherScheme scheme : schemes) {
            List oldGvcList = PersistenceManager.getObjectList(GiftVoucherConfiguration.class, (String)Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).equals(GiftVoucherConfiguration.Properties.INTEGRATION_TYPE, (Object)GiftVoucherIntegrationType.Hive).equals(GiftVoucherConfiguration.Properties.PREFIX, (Object)scheme.getPrefix()).equals(GiftVoucherConfiguration.Properties.UUID_LENGTH, (double)scheme.getTotalLength()).not().equals(GiftVoucherConfiguration.Properties.DEFAULT_EXPIRY_PERIOD, (Object)scheme.getDefaultExpiryPeriod()).equals(GiftVoucherConfiguration.Properties.AUTO_GEN, (Object)scheme.isAutoGenerating()).toString());
            for (GiftVoucherConfiguration giftVoucherConfiguration : oldGvcList) {
                giftVoucherConfiguration.delete();
            }
            GiftVoucherConfiguration gvc = null;
            gvc = scheme.getPrefix() == null || scheme.getPrefix().equals("") ? (GiftVoucherConfiguration)PersistenceManager.getObject(GiftVoucherConfiguration.class, (String)Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).equals(GiftVoucherConfiguration.Properties.LABEL, (Object)scheme.getLabel()).equals(GiftVoucherConfiguration.Properties.INTEGRATION_TYPE, (Object)GiftVoucherIntegrationType.Hive).equals(GiftVoucherConfiguration.Properties.PREFIX, (Object)scheme.getPrefix()).equals(GiftVoucherConfiguration.Properties.UUID_LENGTH, (double)scheme.getTotalLength()).equals(GiftVoucherConfiguration.Properties.DEFAULT_EXPIRY_PERIOD, (Object)scheme.getDefaultExpiryPeriod()).equals(GiftVoucherConfiguration.Properties.AUTO_GEN, (Object)scheme.isAutoGenerating()).toString()) : (GiftVoucherConfiguration)PersistenceManager.getObject(GiftVoucherConfiguration.class, (String)Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).equals(GiftVoucherConfiguration.Properties.INTEGRATION_TYPE, (Object)GiftVoucherIntegrationType.Hive).equals(GiftVoucherConfiguration.Properties.PREFIX, (Object)scheme.getPrefix()).equals(GiftVoucherConfiguration.Properties.UUID_LENGTH, (double)scheme.getTotalLength()).equals(GiftVoucherConfiguration.Properties.DEFAULT_EXPIRY_PERIOD, (Object)scheme.getDefaultExpiryPeriod()).equals(GiftVoucherConfiguration.Properties.AUTO_GEN, (Object)scheme.isAutoGenerating()).toString());
            if (gvc == null) {
                GiftVoucherConfiguration hiveConfig = new GiftVoucherConfiguration(GiftVoucherIntegrationType.Hive);
                hiveConfig.setLabel(scheme.getLabel());
                hiveConfig.setPrefix(scheme.getPrefix());
                hiveConfig.setUuidLength(scheme.getTotalLength());
                hiveConfig.setDefaultExpiryPeriod(scheme.getDefaultExpiryPeriod());
                hiveConfig.setAutoGen(scheme.isAutoGenerating());
                hiveConfig.setSystemState(SystemState.ACTIVE_STATE);
                this.setWebConfig(hiveConfig);
                hiveConfig.save();
                continue;
            }
            if (gvc.getLabel().equals(scheme.getLabel())) continue;
            gvc.setLabel(scheme.getLabel());
            gvc.save();
        }
    }

    private void setWebConfig(GiftVoucherConfiguration hiveConfig) {
        hiveConfig.getWebConfig().setWebserviceType(WebserviceIntegrationType.Basic);
        hiveConfig.getWebConfig().setUsername("HiveUser");
        hiveConfig.getWebConfig().setPassword("tOnh3JW1F7");
        hiveConfig.getWebConfig().setUrl(this.getBaseURL());
    }

    protected long getRedBackId() {
        long rbId = SystemCurrentInfo.getInstance().getRedbackId();
        if (rbId != 0L) {
            return rbId;
        }
        rbId = this.retrieveRedbackId();
        SystemCurrentInfo.getInstance().setRedbackId(rbId);
        SystemCurrentInfo.getInstance().save();
        new NudgeHelper().setNudgeServiceAsDefault();
        return rbId;
    }

    private Long retrieveRedbackId() {
        long updateMateId = SystemCurrentInfo.getInstance().getUpdatemateId();
        WebResource.Builder resource = this.setupResource(null, "common/getRedbackId", new Pair((Object)"updatemateId", (Object)String.valueOf(updateMateId)));
        ClientResponse response = null;
        try {
            response = (ClientResponse)resource.get(ClientResponse.class);
        }
        catch (Exception e) {
            OrderMate.LOG.error("No response from Hive while attempting to retrieve the RedBack store ID!", (Throwable)e);
        }
        if (response != null) {
            String entity = (String)response.getEntity(String.class);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return Long.valueOf(entity);
            }
            OrderMate.LOG.error("Failed to retrieve redback ID for the store with updatemate ID " + updateMateId + "!\r\nResponse: " + entity);
        }
        return 0L;
    }

    private class HiveTrustManager
    extends PassthroughX509TrustManager {
        private HiveTrustManager() {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

