/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.id.ScrambledIdGenerator;
import au.com.ordermate.util.id.UUIDGenerator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherError;
import ordermate.database.finance.giftvoucher.VoucherRequest;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.reports.general.PriceReport;
import servermate.services.voucher.creation.VoucherCreationHelper;
import servermate.services.voucher.creation.VoucherCreationStrategy;
import servermate.services.voucher.expiry.LocalVoucherExpiryHelper;

class LocalVoucherMinion {
    private static final int responseIdLength = 20;
    private Map<String, LockingToken> lockingMap = new ConcurrentHashMap<String, LockingToken>();
    private GiftVoucherConfiguration config;
    private UUIDGenerator authCodeGenerator;
    private ScrambledIdGenerator uniqueIdGenerator;

    public LocalVoucherMinion(GiftVoucherConfiguration voucherConfig) {
        this.config = voucherConfig;
        this.authCodeGenerator = new UUIDGenerator(20, "POS");
        this.uniqueIdGenerator = new ScrambledIdGenerator(this.config.getAutoGenSeed(), voucherConfig.getUuidLength(), voucherConfig.getPrefix());
    }

    public void setConfig(GiftVoucherConfiguration voucherConfig) {
        this.config = voucherConfig;
    }

    protected synchronized GiftVoucher resolveVoucher(String UUID) {
        return (GiftVoucher)PersistenceManager.getObject(GiftVoucher.class, (String)Query.select(GiftVoucher.class).equals(GiftVoucher.Properties.UNIQUE_ID, (Object)UUID).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockVoucher(GiftVoucher voucher) {
        Map<String, LockingToken> map;
        LockingToken lock;
        block12: {
            lock = null;
            map = this.lockingMap;
            synchronized (map) {
                if (!this.lockingMap.containsKey(voucher.getUniqueId())) {
                    this.lockingMap.put(voucher.getUniqueId(), new LockingToken());
                }
                lock = this.lockingMap.get(voucher.getUniqueId());
                ++lock.waiting;
            }
            try {
                if (!lock.access.tryAcquire(this.config.getTimeout(), TimeUnit.SECONDS)) break block12;
                map = this.lockingMap;
                synchronized (map) {
                    --lock.waiting;
                }
                return true;
            }
            catch (InterruptedException e) {
                OrderMate.LOG.error("Interrupted while waiting for gift vouchers.");
            }
        }
        map = this.lockingMap;
        synchronized (map) {
            --lock.waiting;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unlockVoucher(GiftVoucher voucher) {
        Map<String, LockingToken> map = this.lockingMap;
        synchronized (map) {
            LockingToken lock = this.lockingMap.get(voucher.getUniqueId());
            if (lock != null) {
                if (lock.waiting == 0) {
                    this.lockingMap.remove(voucher.getUniqueId());
                }
                lock.access.release();
                return true;
            }
            OrderMate.LOG.warn("Bizarre. The lock that I own has gone walkies.");
            return false;
        }
    }

    protected VoucherResponse lockAndCheck(VoucherRequest request) {
        GiftVoucher voucher = this.resolveVoucher(request.getUUID());
        request.setVoucher(null);
        if (voucher != null) {
            if (this.lockVoucher(voucher)) {
                request.setVoucher((GiftVoucher)PersistenceManager.reacquire((PersistentObjectI)voucher));
                return null;
            }
            return this.fail(request, VoucherError.CANNOT_LOCK);
        }
        return this.fail(request, VoucherError.NOT_EXISTS);
    }

    protected VoucherResponse fail(VoucherRequest request, VoucherError error) {
        VoucherResponse response = new VoucherResponse(request, false, null);
        response.setError(error);
        response.setVoucher(request.getVoucher());
        response.setTxn(request.getTransaction());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VoucherResponse createVoucher(VoucherRequest request) {
        VoucherResponse response;
        LocalVoucherMinion localVoucherMinion = this;
        synchronized (localVoucherMinion) {
            this.config = (GiftVoucherConfiguration)PersistenceManager.reacquire((PersistentObjectI)this.config);
            response = this.config.isAutoGen() ? this.doGenerate(request) : this.doCreateExplicit(request);
        }
        return response;
    }

    private VoucherResponse doGenerate(VoucherRequest request) {
        VoucherResponse response;
        if (request.getUUID() != null) {
            response = new VoucherResponse(request, false, null);
            response.setError(VoucherError.CANNOT_GENERATE);
            OrderMate.LOG.warn("Cannot generate an explicit voucher with an explicit UUID.");
        } else {
            GiftVoucher voucher = new GiftVoucher(this.getNextUUID(this.config.getLastVoucherId()));
            voucher.save();
            response = new VoucherResponse(request, true, this.getNextAuthCode());
            response.setVoucher(voucher);
            this.config.setLastVoucherId(this.uniqueIdGenerator.nextSeed(this.config.getLastVoucherId()));
            this.config.save();
        }
        return response;
    }

    private VoucherResponse doCreateExplicit(VoucherRequest request) {
        VoucherCreationStrategy strategy = new VoucherCreationHelper().resolveCreationStrategy(this.config);
        VoucherResponse response = strategy.createVoucher(request);
        if (response != null && response.isApproved()) {
            this.config.setLastVoucherId(request.getUUID());
            this.config.save();
        }
        return response;
    }

    public VoucherResponse checkValid(VoucherRequest request, boolean consume, boolean expiryCheckOperation) {
        GiftVoucher voucher = request.getVoucher();
        GiftVoucherTransaction voucherTxn = request.getTransaction();
        if (voucher == null) {
            return this.fail(request, VoucherError.NOT_EXISTS);
        }
        if (!SystemState.ACTIVE_STATE.equals((Object)voucher.getSystemState())) {
            return this.fail(request, VoucherError.DELETED);
        }
        if (voucherTxn.getAmount() == null || Price.ZERO_DOLLAR.equals((Object)voucherTxn.getAmount())) {
            return this.fail(request, VoucherError.REQUEST_INVALID);
        }
        if (consume && Price.ZERO_DOLLAR.lessThan((Object)voucherTxn.getAmount())) {
            return this.fail(request, VoucherError.REQUEST_INVALID);
        }
        if (!consume && !expiryCheckOperation && Price.ZERO_DOLLAR.greaterThan((Object)request.getTransaction().getAmount())) {
            return this.fail(request, VoucherError.REQUEST_INVALID);
        }
        if (expiryCheckOperation && !request.isValidationBypassed() && !new LocalVoucherExpiryHelper().validateExpiry(request)) {
            return this.fail(request, VoucherError.EXPIRED);
        }
        return null;
    }

    public Price doResync(GiftVoucher voucher) {
        Price price = Price.ZERO_DOLLAR;
        ObjectQuery query = new ObjectQuery().select(1.0, "ID").sum(GiftVoucherTransaction.Properties.AMOUNT, "price");
        query.equals(GiftVoucherTransaction.Properties.GIFT_VOUCHER, (Object)voucher).active(GiftVoucherTransaction.class).group().group().greaterThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).equals(GiftVoucherTransaction.Properties.CONFIRMED, (Object)"1").endGroup().or().group().lessThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).endGroup().endGroup();
        PriceReport report = (PriceReport)PersistenceManager.getObject(PriceReport.class, (String)query.toString());
        price = report.getPrice() != null ? report.getPrice() : Price.ZERO_DOLLAR;
        voucher.setCachedValue(price);
        voucher.save();
        return price;
    }

    public synchronized String getNextAuthCode() {
        String nextSeed = this.authCodeGenerator.nextSeed(this.config.getLastAuthId());
        this.config.setLastAuthId(nextSeed);
        this.config.save();
        return this.authCodeGenerator.getId(nextSeed);
    }

    final String getNextUUID(String lastId) {
        if (this.uniqueIdGenerator == null) {
            throw new IllegalStateException("We cannot generate unique ids if the authority disallows auto-generation.");
        }
        BarcodePrefix prefix = (BarcodePrefix)PersistenceManager.getObject(BarcodePrefix.class, (String)Query.select(BarcodePrefix.class).equals(BarcodePrefix.Properties.INTERNAL, 1.0).equals(BarcodePrefix.Properties.NAME, (Object)BarcodeUtils.BarcodePrefixGroup.GiftVoucher.name()).toString());
        return prefix.getPrefix() + this.uniqueIdGenerator.getId(this.uniqueIdGenerator.nextSeed(lastId));
    }

    private class LockingToken {
        Semaphore access = new Semaphore(1, true);
        volatile int waiting = 0;

        private LockingToken() {
        }
    }
}

