/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherAuthority;
import ordermate.database.finance.giftvoucher.VoucherRequest;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.VoucherTransaction;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesLineItem;

class ServermateVoucherAdMinion {
    private final EventContext context;
    private final VoucherAuthority auth;
    private final GiftVoucherTransaction txn;
    private final List<SalesLineItem> selectedItems;

    ServermateVoucherAdMinion(GiftVoucherTransaction yourTxn, VoucherAuthority yourAuthority, EventContext yourContext) {
        this.context = yourContext;
        this.auth = yourAuthority;
        this.txn = yourTxn;
        this.selectedItems = null;
    }

    ServermateVoucherAdMinion(GiftVoucherTransaction yourTxn, VoucherAuthority yourAuthority, EventContext yourContext, List<SalesLineItem> yourSelectedItems) {
        this.context = yourContext;
        this.auth = yourAuthority;
        this.txn = yourTxn;
        this.selectedItems = yourSelectedItems;
    }

    VoucherResponse cancelTransaction() {
        this.precheckCancelOrReverse(false);
        if (this.txn.isRedeeming()) {
            return this.cancelRedeeming();
        }
        return this.cancelTopup();
    }

    VoucherResponse reverseTransaction() {
        this.precheckCancelOrReverse(true);
        GiftVoucher voucher = this.txn.getGiftVoucher();
        this.logAttempt("Reverse");
        VoucherRequest request = new VoucherRequest(voucher.getUniqueId(), this.txn);
        VoucherResponse response = this.auth.reverseTransaction(request);
        this.logResponse(response);
        if (response != null) {
            if (response.isApproved() && response.getAuthorisationId() != null && response.getTxn().isActive()) {
                VoucherTransaction financeTxn;
                GiftVoucherTransaction responseTxn = response.getTxn();
                if (responseTxn.isPersistent()) {
                    responseTxn = (GiftVoucherTransaction)PersistenceManager.reacquire((PersistentObjectI)response.getTxn());
                }
                if ((financeTxn = responseTxn.getReversedVoucherTransaction().getFinanceTransaction()) != null) {
                    VoucherTransaction inverseTxn = new VoucherTransaction(this.context.getUser(), this.context.getTerminal(), financeTxn.getCashDrawer(), this.context.getShift(), responseTxn);
                    inverseTxn.setPaid(financeTxn.getPaid().negate());
                    inverseTxn.setTendered(financeTxn.getTendered().negate());
                    ItemGroup account = (ItemGroup)PersistenceManager.reacquire((PersistentObjectI)financeTxn.getPayoffGroup());
                    account.addFinanceTransaction((FinanceTransaction)inverseTxn);
                    account.save();
                    responseTxn.setFinanceTransaction(inverseTxn);
                    responseTxn.saveChild();
                }
            }
            return response;
        }
        throw new IllegalStateException("No response was received from Authority for reversing a transaction on " + voucher.getUniqueId());
    }

    VoucherResponse topupVoucher() {
        this.precheck(true);
        GiftVoucher voucher = this.txn.getGiftVoucher();
        this.logAttempt("Topup");
        VoucherRequest request = new VoucherRequest(voucher.getUniqueId(), this.txn);
        VoucherResponse response = this.auth.topupVoucher(request);
        this.logResponse(response);
        if (response != null) {
            if (response.isApproved()) {
                response.getTxn().authorise(response.getAuthorisationId());
                response.getVoucher().save();
            }
            return response;
        }
        throw new IllegalStateException("No response was received from Authority for " + voucher.getUniqueId());
    }

    VoucherResponse redeemVoucher(boolean ignoreExpiry) {
        this.precheck(false);
        GiftVoucher voucher = this.txn.getGiftVoucher();
        this.logAttempt("Redeem");
        Account account = this.txn.getAccount();
        VoucherRequest request = new VoucherRequest(voucher.getUniqueId(), this.txn, ignoreExpiry);
        VoucherResponse response = this.auth.redeemVoucher(request);
        this.logResponse(response);
        if (response != null) {
            if (response.isApproved() && response.getAuthorisationId() != null && response.getTxn().getFinanceTransaction() == null) {
                response.getTxn().authorise(response.getAuthorisationId());
                voucher = response.getVoucher();
                voucher.save();
                VoucherTransaction financeTxn = new VoucherTransaction(this.context.getUser(), this.context.getTerminal(), ((FinanceTransactionContext)this.context).getCashDrawer(), this.context.getShift(), response.getTxn());
                financeTxn.setTransactionReference(response.getTransactionReference());
                response.getTxn().setFinanceTransaction(financeTxn);
                List items = this.selectedItems;
                if (items == null) {
                    items = account.getItems();
                }
                account.addFinanceTransaction((FinanceTransaction)financeTxn, items);
                account.save();
            }
            return response;
        }
        throw new IllegalStateException("No response was received from Authority for " + voucher.getUniqueId());
    }

    private void precheck(boolean isLoading) {
        String error = null;
        if (this.auth == null) {
            error = "Unknown authority for voucher";
        } else if (this.txn.getAmount() == null || Price.ZERO_DOLLAR.equals((Object)this.txn.getAmount())) {
            error = isLoading ? "Cannot topup with zero dollars." : "Cannot redeem zero dollars";
        } else if (isLoading && Price.ZERO_DOLLAR.greaterThan((Object)this.txn.getAmount())) {
            error = "Cannot topup a negative value.";
        } else if (!isLoading && Price.ZERO_DOLLAR.lessThan((Object)this.txn.getAmount())) {
            error = "Cannot redeem a positive value.";
        } else if (this.txn.getGiftVoucher() == null) {
            error = "Voucher is unknown or not available";
        } else if (this.txn.getAccount() == null) {
            error = "Voucher Transactions must have an account.";
        } else if (this.txn.getAuthId() != null) {
            error = "Voucher Transaction has already been performed.";
        } else if (!this.txn.isActive()) {
            error = "Voucher Transaction has been deleted / canceled.";
        } else if (!isLoading && !(this.context instanceof FinanceTransactionContext)) {
            error = "Cannot redeem a voucher without a cashdrawer - please use a FinanceTransactionContext";
        } else if (!isLoading && ((FinanceTransactionContext)this.context).getCashDrawer() == null) {
            error = "Cannot redeem a voucher without a cashdrawer.";
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private void precheckCancelOrReverse(boolean reversal) {
        String operation;
        String error = null;
        String string = operation = reversal ? "reverse" : "cancel";
        if (this.auth == null) {
            error = "Unknown Authority for voucher.";
        } else if (this.txn.getGiftVoucher() == null) {
            error = "Voucher is unknown or not available.";
        } else if (this.txn.getAccount() == null) {
            error = "Voucher Transactions must have an account.";
        } else if (!this.txn.isActive()) {
            error = "Cannot " + operation + " a canceled transaction.";
        } else if (!this.txn.getAccount().isLocked()) {
            error = "Cannot " + operation + " a voucher transaction on an unlocked account.";
        }
        if (reversal && error == null) {
            GiftVoucher theVoucher = this.auth.resyncVoucher(new VoucherRequest(this.txn.getGiftVoucher().getUniqueId(), null)).getVoucher();
            if (!this.txn.isAuthorised()) {
                error = "Cannot " + operation + " an unauthorized voucher transaction.";
            } else if (!this.txn.isConfirmed()) {
                error = "Cannot " + operation + " an unconfirmed voucher transaction.";
            } else if (this.txn.isReversal()) {
                error = "Cannot " + operation + " a reversal voucher transaction.";
            } else if (this.txn.isReversed()) {
                error = "Cannot " + operation + " an already reversed voucher transaction.";
            } else if (this.txn.getAmount().greaterThan((Object)Price.ZERO_DOLLAR) && theVoucher != null && theVoucher.getCachedValue().lessThan((Object)this.txn.getAmount())) {
                error = "Cannot " + operation + " a topup transaction that has been consumed.";
            }
        }
        if (error != null) {
            String txnValue = "Transaction Value: " + this.txn.getAmount().toString(true);
            String voucherCode = "Voucher Code: " + this.txn.getGiftVoucher().getUniqueId();
            String exceptionMsg = error + HtmlUtils.newline((int)2) + txnValue + "<br>" + voucherCode;
            throw new IllegalArgumentException(exceptionMsg);
        }
    }

    private VoucherResponse cancelRedeeming() {
        this.logAttempt("Cancel Redemption");
        VoucherRequest request = new VoucherRequest(this.txn.getGiftVoucher().getUniqueId(), this.txn);
        VoucherResponse response = this.auth.cancelTransaction(request);
        this.logResponse(response);
        if (response != null) {
            VoucherTransaction financeTxn;
            if (response.isApproved() && !response.getTxn().isActive() && (financeTxn = response.getTxn().getFinanceTransaction()) != null) {
                FinanceTransaction accountTxn = null;
                List allTxns = this.txn.getAccount().getFinanceTransactions();
                for (FinanceTransaction nextTxn : allTxns) {
                    if (!financeTxn.equals((Object)nextTxn)) continue;
                    accountTxn = nextTxn;
                    break;
                }
                if (accountTxn != null) {
                    accountTxn.getPayoffGroup().removeFinanceTransaction(accountTxn);
                }
                financeTxn.prepareForSave((SaveContext)this.context);
                financeTxn.deleteChild();
            }
            return response;
        }
        throw new IllegalStateException("No response was received from Authority for " + this.txn.getGiftVoucher().getUniqueId());
    }

    private VoucherResponse cancelTopup() {
        this.logAttempt("Cancel Topup");
        VoucherRequest request = new VoucherRequest(this.txn.getGiftVoucher().getUniqueId(), this.txn);
        VoucherResponse response = this.auth.cancelTransaction(request);
        this.logResponse(response);
        if (response != null) {
            return response;
        }
        throw new IllegalStateException("No response was received from Authority for " + this.txn.getGiftVoucher().getUniqueId());
    }

    private void logAttempt(String attempt) {
        TerminalEventLog.getInst().logVoucherTxnRequest(attempt, this.txn, this.context);
    }

    private void logResponse(VoucherResponse response) {
        if (response == null) {
            String output = "No Response from Voucher Authority " + this.auth.toString();
            OrderMate.LOG.warn(output);
            TerminalEventLog.getInst().logVoucherTxnResponse(output, this.context);
        } else {
            StringBuilder SB = new StringBuilder("Response from auth " + this.auth.toString() + ": ");
            SB.append("Approved? ").append(response.isApproved()).append(", with auth-id: ").append(response.getAuthorisationId()).append("\r\n");
            if (response.getError() != null) {
                SB.append("Error: ").append(response.getError()).append("\r\n");
            }
            if (response.getVoucher() != null) {
                SB.append("Voucher: ").append(response.getVoucher()).append("\r\n");
            }
            OrderMate.LOG.info(SB.toString());
            TerminalEventLog.getInst().logVoucherTxnResponse(SB.toString(), this.context);
        }
    }
}

