/*
 * Decompiled with CFR 0.152.
 */
package servermate.services.voucher;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherAdministrator;
import ordermate.database.finance.giftvoucher.VoucherAuthority;
import ordermate.database.finance.giftvoucher.VoucherRequest;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import servermate.services.voucher.HiveVoucherAuthority;
import servermate.services.voucher.HiveVoucherMinion;
import servermate.services.voucher.LocalVoucherAuthority;
import servermate.services.voucher.ServermateVoucherAdMinion;

public class ServermateVoucherAdministrator
implements VoucherAdministrator {
    private static ServermateVoucherAdministrator instance;
    private final Map<GiftVoucherConfiguration, VoucherAuthority> authorities;
    private VoucherConfirmationGateway confirmation = new VoucherConfirmationGateway();

    public static ServermateVoucherAdministrator getInstance() {
        if (instance == null) {
            instance = new ServermateVoucherAdministrator();
        }
        return instance;
    }

    private ServermateVoucherAdministrator() {
        this.authorities = new LinkedHashMap<GiftVoucherConfiguration, VoucherAuthority>();
    }

    public GiftVoucher getVoucher(String UUID) throws RemoteException {
        VoucherAuthority auth = this.resolve(UUID);
        OrderMate.LOG.info("Requesting voucher of UUID " + UUID + " from " + auth.toString());
        VoucherResponse response = auth.getVoucher(new VoucherRequest(UUID, null));
        if (response != null) {
            return response.getVoucher();
        }
        throw new IllegalStateException("No Response was received from Authority for " + UUID);
    }

    public GiftVoucher resyncVoucher(String UUID) throws RemoteException {
        VoucherAuthority auth = this.resolve(UUID);
        OrderMate.LOG.info("Resyncing voucher of UUID " + UUID + " from " + auth.toString());
        VoucherResponse response = auth.resyncVoucher(new VoucherRequest(UUID, null));
        if (response != null) {
            return response.getVoucher();
        }
        throw new IllegalStateException("No response was received from Authority for " + UUID);
    }

    public VoucherResponse createVoucher(String UUID, boolean forceCreate) throws RemoteException {
        VoucherAuthority auth = this.resolve(UUID);
        OrderMate.LOG.info("Attempting to create voucher of UUID " + UUID + " from " + auth.toString());
        VoucherResponse response = auth.createVoucher(new VoucherRequest(UUID, null, forceCreate));
        if (response != null) {
            return response;
        }
        throw new IllegalStateException("No response was received from Authority for " + UUID);
    }

    public VoucherResponse generateVoucher(GiftVoucherConfiguration config) throws RemoteException {
        VoucherAuthority auth = this.authorities.get(config);
        if (auth == null) {
            config = (GiftVoucherConfiguration)PersistenceManager.getObject(GiftVoucherConfiguration.class, (String)Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).equals(GiftVoucherConfiguration.Properties.AUTO_GEN, 1.0).orderBy(GiftVoucherConfiguration.Properties.ID).toString());
            auth = this.authorities.get(config);
        }
        if (auth == null) {
            OrderMate.LOG.warn("No auto-generating authority could be found.");
            return new VoucherResponse(new VoucherRequest(null), false, null);
        }
        VoucherRequest request = new VoucherRequest(null);
        return auth.createVoucher(request);
    }

    public VoucherResponse topupVoucher(GiftVoucherTransaction txn, EventContext context) throws RemoteException {
        VoucherResponse response = null;
        if (!txn.isActive() || txn.isRedeeming() || txn.isAuthorised()) {
            OrderMate.LOG.warn("An inactive, already authorised or non-consuming voucher transaction requested for topup.");
            response = new VoucherResponse(new VoucherRequest(txn.getGiftVoucher().getUniqueId(), txn), false, null);
        }
        if (response == null) {
            try {
                GiftVoucherTransaction returnedTxn;
                response = this.topupTransaction(txn, context);
                if (response != null && (returnedTxn = response.getTxn()) != null && response.isApproved()) {
                    Account account = txn.getAccount();
                    account.removeVoucherTransaction(txn);
                    account.updateVoucherTransaction(returnedTxn);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot load voucher", (Throwable)ex);
            }
        }
        return response;
    }

    private VoucherResponse topupTransaction(GiftVoucherTransaction txn, EventContext context) {
        VoucherAuthority auth = this.resolve(txn.getGiftVoucher().getUniqueId());
        ServermateVoucherAdMinion minion = new ServermateVoucherAdMinion(txn, auth, context);
        return minion.topupVoucher();
    }

    public VoucherResponse redeemVoucher(GiftVoucherTransaction txn, FinanceTransactionContext context, boolean ignoreExpiry) throws RemoteException {
        VoucherAuthority auth = this.resolve(txn.getGiftVoucher().getUniqueId());
        ServermateVoucherAdMinion minion = new ServermateVoucherAdMinion(txn, auth, (EventContext)context);
        return minion.redeemVoucher(ignoreExpiry);
    }

    public VoucherResponse redeemVoucher(GiftVoucherTransaction txn, FinanceTransactionContext context, boolean ignoreExpiry, List<SalesLineItem> selectedItems) throws RemoteException {
        VoucherAuthority auth = this.resolve(txn.getGiftVoucher().getUniqueId());
        ServermateVoucherAdMinion minion = new ServermateVoucherAdMinion(txn, auth, (EventContext)context, selectedItems);
        return minion.redeemVoucher(ignoreExpiry);
    }

    void confirmTransaction(final GiftVoucherTransaction txn, boolean retry) {
        if (this.confirmation != null) {
            this.confirmation = new VoucherConfirmationGateway();
        }
        if (!retry) {
            this.confirmation.gateway.putIntoQueue((Object)txn);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ((ServermateVoucherAdministrator)ServermateVoucherAdministrator.this).confirmation.gateway.putIntoQueue((Object)txn);
                }
            }).start();
        }
    }

    public VoucherResponse cancelTransaction(GiftVoucherTransaction txn, EventContext context) throws RemoteException {
        if (txn == null) {
            throw new IllegalArgumentException("Cannot cancel a null transaction");
        }
        VoucherAuthority auth = this.resolve(txn.getGiftVoucher().getUniqueId());
        ServermateVoucherAdMinion minion = new ServermateVoucherAdMinion(txn, auth, context);
        return minion.cancelTransaction();
    }

    public VoucherResponse reverseTransaction(GiftVoucherTransaction txn, EventContext context) throws RemoteException {
        if (txn == null) {
            throw new IllegalArgumentException("Cannot reverse a null transaction");
        }
        VoucherAuthority auth = this.resolve(txn.getGiftVoucher().getUniqueId());
        ServermateVoucherAdMinion minion = new ServermateVoucherAdMinion(txn, auth, context);
        VoucherResponse response = minion.reverseTransaction();
        if (response.isApproved()) {
            this.confirmTransaction(response.getTxn(), false);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VoucherAuthority resolve(String UUID) {
        Map<GiftVoucherConfiguration, VoucherAuthority> map = this.authorities;
        synchronized (map) {
            for (VoucherAuthority nextAuth : this.authorities.values()) {
                if (!nextAuth.isHandled(UUID)) continue;
                return nextAuth;
            }
        }
        throw new IllegalStateException("No Voucher Authority can be found for " + UUID);
    }

    public GiftVoucherConfiguration getConfigFor(String UUID) {
        for (VoucherAuthority nextAuth : this.authorities.values()) {
            if (!nextAuth.isHandled(UUID)) continue;
            return nextAuth.getConfiguration();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        Map<GiftVoucherConfiguration, VoucherAuthority> map = this.authorities;
        synchronized (map) {
            new HiveVoucherMinion().persistNewSchemes();
            OrderMate.LOG.info("Initialising Voucher Authorities");
            this.authorities.clear();
            List configs = PersistenceManager.getObjectList(GiftVoucherConfiguration.class, (String)Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).orderBy(GiftVoucherConfiguration.Properties.PREFIX, true).toString());
            for (GiftVoucherConfiguration config : configs) {
                if (GiftVoucherIntegrationType.POS.equals((Object)config.getIntegrationType())) {
                    OrderMate.LOG.info("Adding Authority for: " + config.getLabel());
                    this.addAuthority(config, new LocalVoucherAuthority(config));
                    continue;
                }
                if (GiftVoucherIntegrationType.Hive.equals((Object)config.getIntegrationType())) {
                    OrderMate.LOG.info("Adding Hive Authority: " + config.getLabel());
                    this.addAuthority(config, new HiveVoucherAuthority(config));
                    continue;
                }
                throw new IllegalStateException("Unknown Voucher type " + config.getIntegrationType());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addAuthority(GiftVoucherConfiguration config, VoucherAuthority auth) {
        Map<GiftVoucherConfiguration, VoucherAuthority> map = this.authorities;
        synchronized (map) {
            if (auth != null && !this.authorities.containsKey(config)) {
                this.authorities.put(config, auth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeAuthority(GiftVoucherConfiguration config) {
        Map<GiftVoucherConfiguration, VoucherAuthority> map = this.authorities;
        synchronized (map) {
            this.authorities.remove(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<VoucherAuthority> getAuthorities() {
        Map<GiftVoucherConfiguration, VoucherAuthority> map = this.authorities;
        synchronized (map) {
            return new ArrayList<VoucherAuthority>(this.authorities.values());
        }
    }

    public Integer getVoucherDefaultExpiryPeriod(String UUID) {
        VoucherAuthority auth = this.resolve(UUID);
        if (auth != null) {
            return auth.getVoucherDefaultExpiryPeriod();
        }
        return null;
    }

    public void confirmTransactions(List<GiftVoucherTransaction> voucherTxns) {
        for (GiftVoucherTransaction txn : voucherTxns) {
            if (!txn.isActive() || txn.isConfirmed() || txn.getAccount().isOpen() || this.confirmation.processIncoming(txn)) continue;
            this.confirmation.gateway.putIntoQueue((Object)txn);
        }
    }

    public boolean ping() throws RemoteException {
        return true;
    }

    private class VoucherConfirmationGateway
    implements GatewayProcessor<GiftVoucherTransaction>,
    GatewayNotifier<GiftVoucherTransaction> {
        Gateway<GiftVoucherTransaction> gateway = new Gateway((GatewayProcessor)this, (GatewayNotifier)this);

        public VoucherConfirmationGateway() {
            this.gateway.startService();
        }

        public void notifyProcess(GiftVoucherTransaction processedValue, boolean processSuccessful) {
            if (processSuccessful) {
                OrderMate.LOG.info("Confirmed Voucher transaction of id:" + processedValue.getID());
            } else {
                ServermateVoucherAdministrator.this.confirmTransaction(processedValue, true);
            }
        }

        public synchronized boolean processIncoming(GiftVoucherTransaction toProcess) {
            GiftVoucherTransaction current;
            GiftVoucherTransaction giftVoucherTransaction = current = toProcess.isPersistent() ? (GiftVoucherTransaction)PersistenceManager.reacquire((PersistentObjectI)toProcess) : toProcess;
            if (current.isConfirmed()) {
                toProcess.confirm();
                return true;
            }
            if (!current.isActive()) {
                return true;
            }
            GiftVoucher voucher = current.getGiftVoucher();
            String uuid = voucher.getUniqueId();
            VoucherAuthority auth = ServermateVoucherAdministrator.this.resolve(uuid);
            VoucherRequest request = new VoucherRequest(uuid, current);
            auth.confirmTransaction(request);
            if (current.isConfirmed()) {
                toProcess.confirm();
            }
            return toProcess.isConfirmed();
        }
    }
}

