/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import servermate.servlets.stock.StockServlet;

public abstract class ServerMateServlet
extends HttpServlet {
    public final void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (this.validateRequest(request, response)) {
                this.processGetRequest(request, response);
            }
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Error processing Get request:", (Throwable)ex);
        }
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (this.validateRequest(request, response)) {
                this.processPostRequest(request, response);
            }
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Error processing Post request:", (Throwable)ex);
        }
    }

    private boolean validateRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (Config.getBooleanValue((String)"ignoreAddressValidation") || this instanceof StockServlet) {
            return true;
        }
        String remoteAddress = "/" + request.getRemoteAddr();
        boolean isValid = this.isValidRequestor(remoteAddress);
        if (isValid) {
            OrderMateLog.LOG.info("Device requesting service accepted:" + remoteAddress);
        } else {
            OrderMateLog.LOG.warn("Incoming request rejected, invalid requestor:" + remoteAddress);
            response.sendError(403);
        }
        return isValid;
    }

    private boolean isValidRequestor(String address) {
        return address.equals("/127.0.0.1");
    }

    protected abstract void processPostRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected abstract void processGetRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
}

