/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import ordermate.OrderMate;
import servermate.servlets.filter.AbstractFilter;

public class IPAddressFilter
extends AbstractFilter {
    private static final String TOM_80_ADDRESS = "119.9.13.199";
    static final String ALLOW_ALL_IP_CHAR = "*";
    private boolean remoteIPAllowed;
    private List<String> allowedIPAddresses;

    public IPAddressFilter(boolean remoteIPAllowed, List<String> allowedIPAddresses) {
        this.remoteIPAllowed = remoteIPAllowed;
        this.allowedIPAddresses = allowedIPAddresses;
    }

    @Override
    protected boolean applyFilter(ServletRequest req, ServletResponse resp) {
        String here;
        String there = req.getRemoteAddr();
        boolean allGood = this.isLocalIPAddress(there, here = req.getLocalAddr());
        if (!allGood && this.remoteIPAllowed) {
            allGood = this.isAllowedRemoteIPAddress(there);
        }
        if (!allGood) {
            OrderMate.LOG.info("Non-local or allowed remote request coming from :" + there);
            try {
                resp.getOutputStream().print("<html>Invalid request location</html>");
            }
            catch (IOException ex) {
                OrderMate.LOG.warn("Error writing invalid request.", (Throwable)ex);
            }
            return false;
        }
        return allGood;
    }

    private boolean isLocalIPAddress(String requestIpAddress, String localIpAddress) {
        if ("localhost".equals(requestIpAddress)) {
            return true;
        }
        if ("0:0:0:0:0:0:0:1".equals(requestIpAddress)) {
            return true;
        }
        if (requestIpAddress == null || localIpAddress == null) {
            return false;
        }
        if (!localIpAddress.contains(".")) {
            OrderMate.LOG.warn("Unexpected IP format. String=\"" + localIpAddress + "\"");
            return false;
        }
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            index = localIpAddress.indexOf(".", index + 1);
        }
        String prefix = localIpAddress.substring(0, index);
        return requestIpAddress.startsWith(prefix);
    }

    private boolean isAllowedRemoteIPAddress(String requestIpAddress) {
        return this.allowedIPAddresses.contains(ALLOW_ALL_IP_CHAR) || this.allowedIPAddresses.contains(requestIpAddress) || TOM_80_ADDRESS.equals(requestIpAddress);
    }
}

