/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.filter;

import ar.com.fdvs.dj.util.StreamUtils;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.config.LoggingStrategy;
import ordermate.database.config.webresource.WebResourceLogConfig;
import ordermate.database.misc.WebResourceLog;
import ordermate.database.misc.WebResourceLogExt;
import servermate.servlets.filter.AbstractFilter;

public class LoggingFilter
extends AbstractFilter {
    private final int MAX_LOG_SIZE = 10240;
    private final int END_OF_MESSAGE = -1;
    private final WebResourceLogConfig logConfig;

    public LoggingFilter(WebResourceLogConfig logConfig) {
        this.logConfig = logConfig;
    }

    @Override
    protected boolean applyFilter(ServletRequest req, ServletResponse resp) {
        HttpServletRequest http = (HttpServletRequest)req;
        WebResourceLog resourceLog = new WebResourceLog(http.getMethod(), http.getRequestURI(), http.getRemoteAddr(), http.getRemoteHost(), http.getRemoteUser());
        resourceLog.setQueryString(http.getQueryString());
        resourceLog.save();
        if (LoggingStrategy.ALWAYS.equals((Object)this.logConfig.getRequestLogStrategy())) {
            WebResourceLogExt logExt = new WebResourceLogExt(resourceLog);
            this.saveRequestLog(req, logExt);
        }
        MultiReadHttpServletRequest multiReadHttp = (MultiReadHttpServletRequest)http;
        multiReadHttp.setLogId(resourceLog.getID());
        return true;
    }

    private void saveRequestLog(ServletRequest req, WebResourceLogExt logExt) {
        String requestBodyLog = this.getRequestBodyLog(req);
        String requestHeaderLog = this.getRequestHeaderLog(req);
        logExt.setRequestHeader(requestHeaderLog);
        logExt.setRequestBody(requestBodyLog);
        logExt.save();
    }

    private void saveResponseLog(ServletResponse resp, WebResourceLogExt logExt) {
        String responseBodyLog = this.getResponseBodyLog(resp);
        logExt.setResponseBody(responseBodyLog);
        logExt.save();
    }

    private String getRequestHeaderLog(ServletRequest req) {
        StringBuilder SB = new StringBuilder("Incoming Request:").append(req.getProtocol());
        SB.append("\r\n");
        if (req instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)req;
            SB.append(http.getMethod()).append(" ").append(http.getContextPath());
            Enumeration en = ((HttpServletRequest)req).getHeaderNames();
            while (en.hasMoreElements()) {
                String header = (String)en.nextElement();
                SB.append(header).append(":").append(http.getHeader(header)).append("\r\n");
            }
        }
        return SB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestBodyLog(ServletRequest req) {
        ServletInputStream buffread = null;
        try {
            buffread = req.getInputStream();
            String string = StringUtils.readFromStream((InputStream)buffread, (int)-1, (int)10240);
            return string;
        }
        catch (IOException e) {
            OrderMate.LOG.warn("LoggingFilter - IOException is thrown while getting body text!");
        }
        finally {
            if (buffread != null) {
                try {
                    buffread.close();
                }
                catch (IOException e) {
                    OrderMate.LOG.warn("LoggingFilter - IOException is thrown while closing input stream in getting body log!");
                }
            }
        }
        return "";
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        MultiReadHttpServletRequest reqWrapped = new MultiReadHttpServletRequest((HttpServletRequest)req);
        MultiReadHttpServletResponse respWrapped = new MultiReadHttpServletResponse((HttpServletResponse)resp);
        if (this.applyFilter((ServletRequest)reqWrapped, (ServletResponse)respWrapped) && chain != null) {
            chain.doFilter((ServletRequest)reqWrapped, (ServletResponse)respWrapped);
        }
        this.postProcess((ServletRequest)reqWrapped, (ServletResponse)respWrapped);
    }

    @Override
    protected void postProcess(ServletRequest req, ServletResponse resp) {
        this.updateLogForResponse(req, resp);
    }

    private void updateLogForResponse(ServletRequest req, ServletResponse resp) {
        MultiReadHttpServletRequest multiReadRequest = (MultiReadHttpServletRequest)req;
        WebResourceLog resourceLog = (WebResourceLog)PersistenceManager.getByID((long)multiReadRequest.getLogId(), WebResourceLog.class);
        if (resourceLog != null) {
            MultiReadHttpServletResponse httpResponse = (MultiReadHttpServletResponse)resp;
            this.updateResponseStatus(resourceLog, httpResponse);
            this.saveResourceLogExt(req, httpResponse, resourceLog);
        }
    }

    private void saveResourceLogExt(ServletRequest req, MultiReadHttpServletResponse httpResponse, WebResourceLog resourceLog) {
        boolean isRequestLoggingEnabled = this.shouldLogRequest(httpResponse.getStatus());
        boolean isResponseLoggingEnabled = this.shouldLogResponse(httpResponse.getStatus());
        if (isRequestLoggingEnabled || isResponseLoggingEnabled) {
            WebResourceLogExt resourceLogExt = (WebResourceLogExt)PersistenceManager.getObject(WebResourceLogExt.class, (String)Query.select(WebResourceLogExt.class).equals(WebResourceLogExt.Properties.WEB_RESOURCE_LOG, (Object)resourceLog).toString());
            if (resourceLogExt != null) {
                if (isResponseLoggingEnabled) {
                    this.saveResponseLog((ServletResponse)httpResponse, resourceLogExt);
                }
            } else {
                WebResourceLogExt logExt = new WebResourceLogExt(resourceLog);
                if (isRequestLoggingEnabled) {
                    this.saveRequestLog(req, logExt);
                }
                if (isResponseLoggingEnabled) {
                    this.saveResponseLog((ServletResponse)httpResponse, logExt);
                }
            }
        }
    }

    private void updateResponseStatus(WebResourceLog resourceLog, MultiReadHttpServletResponse httpResponse) {
        resourceLog.setResponseStatus(httpResponse.getStatus());
        resourceLog.save();
    }

    private boolean shouldLogResponse(int responseStatus) {
        return this.shouldLog(this.logConfig.getResponseLogStrategy(), responseStatus);
    }

    private boolean shouldLogRequest(int responseStatus) {
        return this.shouldLog(this.logConfig.getRequestLogStrategy(), responseStatus);
    }

    private boolean shouldLog(LoggingStrategy loggingStrategy, int responseStatus) {
        return LoggingStrategy.ALWAYS.equals((Object)loggingStrategy) || LoggingStrategy.ON_FAIL.equals((Object)loggingStrategy) && Response.Status.OK.getStatusCode() != responseStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponseBodyLog(ServletResponse resp) {
        String bodyString = null;
        InputStream respInput = null;
        try {
            MultiReadHttpServletResponse respWrapped = (MultiReadHttpServletResponse)resp;
            respInput = new ByteArrayInputStream(respWrapped.getByteOutput());
            bodyString = StringUtils.readFromStream((InputStream)respInput, (int)-1, (int)10240);
        }
        catch (IOException e) {
            OrderMate.LOG.warn("LoggingFilter - IOException is thrown while getting response body text!");
        }
        finally {
            if (respInput != null) {
                try {
                    respInput.close();
                }
                catch (IOException e) {
                    OrderMate.LOG.warn("LoggingFilter - IOException is thrown while closing the input stream in getting response body text!");
                }
            }
        }
        return bodyString;
    }

    public static class MultiReadHttpServletResponse
    extends HttpServletResponseWrapper {
        private ServletOutputStream outputStream;
        private ServletOutputStreamImpl copiedOutput;
        private PrintWriter writer;
        private int httpStatus;

        public MultiReadHttpServletResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public String getCopiedOutput() throws IOException {
            if (this.copiedOutput != null) {
                return new String(this.copiedOutput.getCopy(), this.getCharacterEncoding());
            }
            return "";
        }

        public byte[] getByteOutput() {
            if (this.copiedOutput != null) {
                return this.copiedOutput.getCopy();
            }
            return new byte[0];
        }

        void setCopiedOutput(ByteArrayOutputStream output) throws IOException {
            this.copiedOutput = new ServletOutputStreamImpl(output);
            this.copiedOutput.write(output.toByteArray());
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            } else if (this.outputStream != null) {
                this.copiedOutput.flush();
            }
        }

        public String getCharacterEncoding() {
            if (this.getResponse().getCharacterEncoding() == null) {
                this.getResponse().setCharacterEncoding("UTF-8");
            }
            return this.getResponse().getCharacterEncoding();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.outputStream != null) {
                throw new IllegalStateException("getOutputStream() has already been called on this response.");
            }
            if (this.writer == null) {
                this.copiedOutput = new ServletOutputStreamImpl((OutputStream)this.getResponse().getOutputStream());
                this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copiedOutput), this.getCharacterEncoding()), true);
            }
            return this.writer;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("getWriter() has already been called on this response.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.getResponse().getOutputStream();
                this.copiedOutput = new ServletOutputStreamImpl((OutputStream)this.outputStream);
            }
            return this.copiedOutput;
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        private class ServletOutputStreamImpl
        extends ServletOutputStream {
            private OutputStream os;
            private ByteArrayOutputStream copy = new ByteArrayOutputStream(1024);

            public ServletOutputStreamImpl(OutputStream outputStream) {
                this.os = outputStream;
            }

            public void write(int b) throws IOException {
                this.os.write(b);
                this.copy.write(b);
            }

            public byte[] getCopy() {
                return this.copy.toByteArray();
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        }
    }

    public class MultiReadHttpServletRequest
    extends HttpServletRequestWrapper {
        private byte[] body;
        private long logId;

        public MultiReadHttpServletRequest(HttpServletRequest httpServletRequest) {
            super(httpServletRequest);
            try {
                this.init();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("LoggingFilter - IOException is thrown in MultiReadHttpServletRequest initialization", (Throwable)ex);
            }
        }

        private void init() throws IOException {
            try (ServletInputStream inputStream = null;){
                inputStream = super.getInputStream();
                this.body = StreamUtils.getBytes((InputStream)inputStream);
            }
        }

        public ServletInputStream getInputStream() throws IOException {
            return new ServletInputStreamImpl(new ByteArrayInputStream(this.body));
        }

        public BufferedReader getReader() throws IOException {
            String enc = this.getCharacterEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), enc));
        }

        public long getLogId() {
            return this.logId;
        }

        public void setLogId(long logId) {
            this.logId = logId;
        }

        private class ServletInputStreamImpl
        extends ServletInputStream {
            private InputStream is;

            public ServletInputStreamImpl(InputStream is) {
                this.is = is;
            }

            public int read() throws IOException {
                return this.is.read();
            }

            public boolean markSupported() {
                return false;
            }

            public synchronized void mark(int i) {
                throw new RuntimeException(new IOException("mark/reset not supported"));
            }

            public synchronized void reset() throws IOException {
                throw new IOException("mark/reset not supported");
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        }
    }
}

