/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.jersey;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.List;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.config.webresource.WebResource;
import ordermate.database.config.webresource.WebResourceLogConfig;
import ordermate.database.misc.license.LicenseType;
import org.eclipse.jetty.servlet.ServletHolder;
import servermate.servlets.ServerMateServer;
import servermate.servlets.jersey.CORSFilter;
import servermate.servlets.jersey.OMJaxbJSonProvider;

public class WebResourceSetup {
    private final WebResource resource;

    public WebResourceSetup(WebResource resource) {
        this.resource = resource;
    }

    public void setupContainer(ServerMateServer server) {
        String clazzes = this.resource.getResourceType().getClassPath();
        OrderMate.LOG.info("Setting up jersey servlet:" + this.toString());
        PackagesResourceConfig app = new PackagesResourceConfig(new String[]{clazzes});
        app.getContainerResponseFilters().add(new CORSFilter());
        ExperimentalFeature exp = ExperimentalFeature.find((String)"Legacy JSON");
        if (exp == null) {
            exp = new ExperimentalFeature("Legacy JSON", Boolean.TRUE.toString());
            exp.save();
        }
        if (exp != null && exp.getBooleanValue(Boolean.TRUE).booleanValue()) {
            app.getClasses().add(OMJaxbJSonProvider.class);
        } else {
            app.getClasses().add(JacksonJaxbJsonProvider.class);
        }
        ServletHolder sh = new ServletHolder((Servlet)new ServletContainer((Application)app));
        sh.setInitParameter("com.sun.jersey.config.property.packages", "com.fasterxml.jackson.jaxrs");
        sh.setInitParameter("jersey.config.server.provider.classnames", "servermate.servlets.jersey.OMJaxbJSonProvider");
        sh.setInitParameter("jersey.config.disableMoxyJson", "true");
        sh.setInitParameter("jersey.config.disableJsonProcessing", "true");
        server.applyServletHolder(sh, this.getContext());
    }

    protected String getContext() {
        return this.resource.getActualContext();
    }

    protected String getContextPath() {
        return this.resource.getActualContext();
    }

    protected String getResourceLocation() {
        return this.resource.getResourceType().getClassPath();
    }

    public boolean isRequiresIPFilter() {
        return this.resource.isIpRestricted();
    }

    public boolean isRequiresUserFilter() {
        return this.resource.isSecure();
    }

    public boolean requiresLogging() {
        return this.resource.getLogConfig().isEnabled();
    }

    public List<String> getWhiteList() {
        return this.resource.getActualWhiteList();
    }

    public WebResourceLogConfig getLogConfig() {
        return this.resource.getLogConfig();
    }

    public WebResource getResource() {
        return this.resource;
    }

    public LicenseType getLicenseType() {
        return this.resource.getResourceType().getLicenseType();
    }

    public String toString() {
        StringBuilder SB = new StringBuilder(this.resource.getResourceType().name());
        SB.append(" secure: ").append(this.resource.isSecure());
        SB.append(" ip_res: ").append(this.resource.isIpRestricted());
        SB.append(" logs: ").append(this.resource.getLogConfig());
        return SB.toString();
    }
}

