/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.payattable;

import au.com.payback.xmlintegration.payattable.ObjectFactory;
import au.com.payback.xmlintegration.payattable.PaTError;
import java.util.HashMap;
import java.util.Map;

class PayAtTableErrors {
    static final Integer CODE_ERROR_UNKNOWN_ACCOUNT = 100;
    static final Integer CODE_ERROR_UNKNOWN_USER = 110;
    static final Integer CODE_ERROR_ACC_ALREADY_LOCKED = 200;
    static final Integer CODE_ERROR_ACC_ALREADY_CLOSED = 210;
    static final Integer CODE_ERROR_ACC_CANNOT_LOCK = 220;
    static final Integer CODE_ERROR_PAY_NO_CASHDRAWER = 300;
    static final Integer CODE_ERROR_DUPLICATE_TRANSACTION = 400;
    static final Integer CODE_ERROR_PAY_INTERNAL = 500;
    static final String ERROR_UNKNOWN_ACCOUNT = "Invalid account ID of ";
    static final String ERROR_UNKNOWN_USER = "Invalid user ID of ";
    private static final String ERROR_ACC_ALREADY_LOCKED = "This account is already in use by ";
    private static final String ERROR_ACC_ALREADY_CLOSED = "This account is already closed.";
    private static final String ERROR_ACC_CANNOT_LOCK = "A lock on this account could not be acquired.";
    private static final String ERROR_PAY_NO_CASHDRAWER = "A cashdrawer is required in order to proceed with a payment (a cashdrawer was not found).";
    private static final String ERROR_DUPLICATE_TRANSACTION = "A transaction with this UUID has already been submitted and processed by ServerMate.";
    private static final String ERROR_PAY_INTERNAL = "An internal error occurred while attempting to apply a payment.";
    private static final Map<Integer, PaTError> errorMap = new HashMap<Integer, PaTError>();

    PayAtTableErrors() {
    }

    private static final PaTError buildError(Integer code, String message) {
        ObjectFactory of = new ObjectFactory();
        PaTError error = of.createPaTError();
        error.setErrorCode(code);
        error.setErrorMessage(message);
        return error;
    }

    static final PaTError getError(Integer code) {
        PaTError toClone = errorMap.get(code);
        return PayAtTableErrors.buildError(toClone.getErrorCode(), toClone.getErrorMessage());
    }

    static final PaTError appendStringToMessage(PaTError error, String message) {
        error.setErrorMessage(error.getErrorMessage() + message);
        return error;
    }

    static {
        errorMap.put(CODE_ERROR_UNKNOWN_ACCOUNT, PayAtTableErrors.buildError(CODE_ERROR_UNKNOWN_ACCOUNT, ERROR_UNKNOWN_ACCOUNT));
        errorMap.put(CODE_ERROR_UNKNOWN_USER, PayAtTableErrors.buildError(CODE_ERROR_UNKNOWN_USER, ERROR_UNKNOWN_USER));
        errorMap.put(CODE_ERROR_ACC_ALREADY_LOCKED, PayAtTableErrors.buildError(CODE_ERROR_ACC_ALREADY_LOCKED, ERROR_ACC_ALREADY_LOCKED));
        errorMap.put(CODE_ERROR_ACC_ALREADY_CLOSED, PayAtTableErrors.buildError(CODE_ERROR_ACC_ALREADY_CLOSED, ERROR_ACC_ALREADY_CLOSED));
        errorMap.put(CODE_ERROR_ACC_CANNOT_LOCK, PayAtTableErrors.buildError(CODE_ERROR_ACC_CANNOT_LOCK, ERROR_ACC_CANNOT_LOCK));
        errorMap.put(CODE_ERROR_PAY_NO_CASHDRAWER, PayAtTableErrors.buildError(CODE_ERROR_PAY_NO_CASHDRAWER, ERROR_PAY_NO_CASHDRAWER));
        errorMap.put(CODE_ERROR_DUPLICATE_TRANSACTION, PayAtTableErrors.buildError(CODE_ERROR_DUPLICATE_TRANSACTION, ERROR_DUPLICATE_TRANSACTION));
        errorMap.put(CODE_ERROR_PAY_INTERNAL, PayAtTableErrors.buildError(CODE_ERROR_PAY_INTERNAL, ERROR_PAY_INTERNAL));
    }
}

