/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.payattable;

import au.com.ordermate.dockets.HtmlReceiptCommander;
import au.com.ordermate.dockets.PrintCommanderInterface;
import au.com.ordermate.dockets.XMLDocketScanner;
import au.com.ordermate.message.SMS;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import au.com.payback.xmlintegration.payattable.PaTAccountItem;
import au.com.payback.xmlintegration.payattable.PaTAccountRequest;
import au.com.payback.xmlintegration.payattable.PaTError;
import au.com.payback.xmlintegration.payattable.PaTPaymentResult;
import au.com.payback.xmlintegration.payattable.PaTResult;
import au.com.payback.xmlintegration.payattable.PaTUser;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.feedback.FeedbackAnswer;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.feedback.FeedbackResponse;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.integration.adyen.AdyenIntegrationConfig;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.hardware.ReceiptPrinterQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;
import ordermate.integration.cloudback.nudge.NudgeManager;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.integration.jaxb.feedback.FBAnswer;
import ordermate.integration.jaxb.feedback.FBQuestion;
import ordermate.integration.jaxb.feedback.FeedBack;
import ordermate.integration.nudgeback.EmailBuilder;
import ordermate.integration.opay.OpaySettingsConfig;
import ordermate.integration.opay.OpayTippingConfig;
import ordermate.misc.ObjectMarshaller;
import ordermate.reports.printing.InvoiceReport;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.adyen.AdyenConfigResponse;
import org.apache.logging.log4j.Level;
import org.xml.sax.SAXException;
import servermate.servlets.payattable.PayAtTableEntityHelper;
import servermate.servlets.payattable.PayAtTableErrors;
import servermate.servlets.payattable.PayAtTableResourceHelper;

@Path(value="")
public class SMPayAtTableResource
extends AbstractResource {
    private static final long SYSTEM_USER = -396762457L;
    private static final String EMAIL_MESSAGE = "Your Receipt Is Attached";
    private static final String ADYEN_VERSION = "v1";
    private static final String GB_VERSION = "v8";
    private static Map<String, PaTPaymentResult> applyingPayments = new ConcurrentHashMap<String, PaTPaymentResult>();
    private final NudgeUtil nudgeUtil = new NudgeUtil();

    @Path(value="authoriseUser")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @POST
    public Response authoriseUser(PaTUser user) {
        User authorisedUser;
        String pin = user.getPinString();
        if (pin == null && user.getPin() != null) {
            pin = user.getPin().toString();
        }
        if ((authorisedUser = User.getUserByPin((String)pin)) != null && !authorisedUser.hasPermission(AllPermissions.PAY)) {
            user.setError("Invalid Permissions for User to Log In");
            return Response.ok((Object)user).build();
        }
        return Response.ok((Object)PayAtTableEntityHelper.convertUser(authorisedUser, user)).build();
    }

    @Path(value="authoriseAdminUser")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @POST
    public Response authoriseAdminUser(PaTUser user) {
        User authorisedUser;
        String pin = user.getPinString();
        if (pin == null && user.getPin() != null) {
            pin = user.getPin().toString();
        }
        if ((authorisedUser = User.getUserByPin((String)pin)) != null && !authorisedUser.hasPermission(AllPermissions.ACCESS_OPAY_SETTINGS)) {
            user.setError("Invalid Permissions for User to Log In");
            return Response.ok((Object)user).build();
        }
        return Response.ok((Object)PayAtTableEntityHelper.convertUser(authorisedUser, user)).build();
    }

    @Path(value="splitQuantities")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @POST
    public Response splitQuantities(PaTAccountItem item) {
        SalesLineItem s = (SalesLineItem)PersistenceManager.getByID((long)item.getId(), SalesItem.class);
        if (s == null) {
            return Response.status((int)404).build();
        }
        if (!s.isSplittable()) {
            return Response.status((int)404).build();
        }
        User user = User.getSystemUser();
        Terminal terminal = Terminal.getServerMateTerminal();
        while (SalesQuantity.ONE.lessThan(s.getQuantity())) {
            SalesLineItem newItem = s.split(SalesQuantity.ONE, new EventContext(terminal, user));
            newItem.saveChild();
            s.saveChild();
        }
        s = (SalesLineItem)PersistenceManager.reacquire((PersistentObjectI)s);
        return Response.ok((Object)PayAtTableEntityHelper.convertAccount(s.getAccount())).build();
    }

    @Path(value="getOpenAccounts")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @GET
    public Response getOpenAccounts(@QueryParam(value="accountType") String accountType) {
        AccountType accType = PayAtTableResourceHelper.resolveAccountType(accountType);
        List openAccounts = Account.getOpenAccounts((AccountType)accType);
        if (accType.equals((Object)AccountType.tableType)) {
            openAccounts.addAll(Account.getOpenAccounts((AccountType)AccountType.onlineTableType));
        }
        return Response.ok((Object)PayAtTableEntityHelper.convertAccountList(openAccounts)).build();
    }

    @Path(value="lockAccount")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @POST
    public Response lockAccount(PaTAccountRequest request) {
        Account acc = this.getAccountForRequest(request);
        if (acc == null) {
            return this.getBadRequestResponse("Invalid account ID of " + request.getAccountId());
        }
        User user = this.determineUser(request.getUserId());
        if (user == null) {
            return this.getBadRequestResponse("Invalid user ID of " + request.getUserId());
        }
        if (!acc.isOpen()) {
            request.setSuccess(Boolean.FALSE);
            request.setError(PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_ACC_ALREADY_CLOSED));
            return Response.ok((Object)request).build();
        }
        request.setAccountInfo(PayAtTableEntityHelper.convertAccount(acc));
        if (request.isLock()) {
            if (acc.isLocked()) {
                request.setSuccess(Boolean.FALSE);
                PaTError error = PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_ACC_ALREADY_LOCKED);
                error = PayAtTableErrors.appendStringToMessage(error, acc.getUser().toString());
                request.setError(error);
                return Response.ok((Object)request).build();
            }
            boolean result = acc.lock(user);
            if (!result) {
                PaTError error = PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_ACC_CANNOT_LOCK);
                request.setError(error);
            }
            request.setSuccess(Boolean.valueOf(result));
            return Response.ok((Object)request).build();
        }
        acc.save();
        acc.unlock();
        request.setSuccess(Boolean.TRUE);
        return Response.ok((Object)request).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="applyPayment")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    @POST
    public Response applyPayment(PaTPaymentResult payment) {
        Map<String, PaTPaymentResult> map = applyingPayments;
        synchronized (map) {
            if (PaTResult.DENIED.equals((Object)payment.getStatus()) || PaTResult.ERROR.equals((Object)payment.getStatus())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)payment).build();
            }
            if (applyingPayments.containsKey(payment.getTransactionUuid())) {
                PaTError error = PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_DUPLICATE_TRANSACTION);
                payment.setStatus(PaTResult.ERROR);
                payment.setError(error);
                OrderMate.LOG.info("Transaction with reference: " + payment.getTransactionUuid() + " already in progress");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)payment).build();
            }
            applyingPayments.put(payment.getTransactionUuid(), payment);
            OrderMate.LOG.info("Incoming PaTPaymentResult for " + payment.getAccountId() + " Total:" + payment.getPaid() + " Surch:" + payment.getSurcharge());
            PayAtTableResourceHelper helper = new PayAtTableResourceHelper();
            if (helper.isDuplicateTransaction(payment)) {
                PaTError error = PayAtTableErrors.getError(PayAtTableErrors.CODE_ERROR_DUPLICATE_TRANSACTION);
                payment.setStatus(PaTResult.ERROR);
                payment.setError(error);
                applyingPayments.remove(payment.getTransactionUuid());
                OrderMate.LOG.info("Transaction with reference: " + payment.getTransactionUuid() + " already existing in db");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)payment).build();
            }
            PaTPaymentResult result = helper.doPayment(payment);
            applyingPayments.remove(payment.getTransactionUuid());
            return !PaTResult.ERROR.equals((Object)result.getStatus()) ? Response.ok((Object)result).build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)result).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="accountInfo")
    public Response getAccountInfo(PaTAccountRequest request) {
        Account account = this.getAccountForRequest(request);
        if (account != null && AccountState.OPEN.equals((Object)account.getAccountState())) {
            return Response.ok((Object)PayAtTableEntityHelper.convertAccount(account)).build();
        }
        OrderMate.LOG.log(Level.WARN, "Account is null or closed. Request denied: " + account);
        return Response.noContent().build();
    }

    public AdyenConfigResponse buildValidateCashdrawerResponse() {
        PayAtTableResourceHelper helper = new PayAtTableResourceHelper();
        Terminal.reacquireServerMateTerminal();
        CashDrawer cd = helper.resolveCashDrawer(Terminal.getServerMateTerminal());
        if (cd == null) {
            return null;
        }
        AdyenConfigResponse r = new AdyenConfigResponse();
        r.setVersionName("v8;v1");
        r.setSurcharge(AdyenIntegrationConfig.getInstance().getSurchargeRate().doubleValue());
        r.setZeroDollarItems(SystemProperty.getInstance().isPrintZeroDollarItems());
        return r;
    }

    @Path(value="validateCashdrawer")
    @Produces(value={"application/json"})
    @GET
    public Response validateCashdrawer(@QueryParam(value="terminalID") String terminalId) {
        AdyenConfigResponse r = this.buildValidateCashdrawerResponse();
        if (r == null) {
            return Response.status((int)404).entity((Object)"Error: Cashdrawer not assigned to ServerMate").build();
        }
        if (terminalId != null && !terminalId.isEmpty()) {
            VirtualEftpos t = (VirtualEftpos)PersistenceManager.getObject(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).equals(VirtualEftpos.Properties.TERMINAL_ID, (Object)terminalId).active(VirtualEftpos.class).toString());
            if (t == null) {
                return Response.status((int)404).entity((Object)"Error: Cashdrawer not assigned to ServerMate").build();
            }
            OpayTippingConfig c = (OpayTippingConfig)PersistenceManager.getObject(OpayTippingConfig.class, (String)Query.select(OpayTippingConfig.class).equals(OpayTippingConfig.Properties.EFTPOS, (Object)t.getID()).toString());
            if (c != null) {
                r.setTipDefaultOne(c.getTippingDefaultFirst());
                r.setTipDefaultTwo(c.getTippingDefaultSecond());
                r.setTipDefaultThree(c.getTippingDefaultThird());
                r.setTipDefaultOneLine(c.getTippingDefaultFirstLine());
                r.setTipDefaultTwoLine(c.getTippingDefaultSecondLine());
                r.setTipDefaultThreeLine(c.getTippingDefaultThirdLine());
            } else {
                r.setTipDefaultOne(5.0);
                r.setTipDefaultTwo(10.0);
                r.setTipDefaultThree(15.0);
                r.setTipDefaultOneLine("Good");
                r.setTipDefaultTwoLine("Great");
                r.setTipDefaultThreeLine("Amazing");
            }
            OpaySettingsConfig s = (OpaySettingsConfig)PersistenceManager.getObject(OpaySettingsConfig.class, (String)Query.select(OpaySettingsConfig.class).equals(OpaySettingsConfig.Properties.EFTPOS, (Object)t.getID()).toString());
            if (s != null) {
                r.setItemSplitEnabled(Boolean.valueOf(s.isItemSplitEnabled()));
                r.setPatronSplitEnabled(Boolean.valueOf(s.isPatronSplitEnabled()));
                r.setSplitBillEnabled(Boolean.valueOf(s.isSplitBillEnabled()));
                r.setTippingEnabled(Boolean.valueOf(s.isTippingEnabled()));
                if (s.getCashdrawer() != null) {
                    r.setCashdrawerId((long)s.getCashdrawer().getID().intValue());
                } else {
                    r.setCashdrawerId(0L);
                }
            }
        }
        ArrayList<String> acceptedReceipts = new ArrayList<String>();
        if (NudgeManager.isNudgeConfigured()) {
            acceptedReceipts.add("EMAIL");
        }
        r.setReceiptConfig(acceptedReceipts);
        return Response.ok((Object)SMPayAtTableResource.toJson(r)).build();
    }

    public static String toJson(Object obj) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper = mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper = mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper = mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
            mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
            String result = mapper.writeValueAsString(obj);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Path(value="sendReceipt")
    @Produces(value={"application/json"})
    @GET
    public Response sendReceipt(@QueryParam(value="email") boolean email, @QueryParam(value="location") String location, @QueryParam(value="account") Long AccountID, @QueryParam(value="userId") Long UserID) throws Exception {
        boolean success = false;
        String receiptStr = "";
        User user = (User)PersistenceManager.getByID((long)UserID, User.class);
        Account a = (Account)PersistenceManager.getByID((long)AccountID, Account.class);
        if (email) {
            InvoiceReport invoiceReport = new InvoiceReport("/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
            invoiceReport.setAccount((ItemGroup)a);
            invoiceReport.generate();
            String fileName = String.format("C:\\temp\\%s.pdf", a.getID());
            JasperPrintManager.printReportToPdfFile((JasperPrint)invoiceReport.getReport(), (String)fileName);
            String invoiceEmail = this.getInvoiceEmail((ItemGroup)a, user);
            EmailBuilder emailBuilder = new EmailBuilder("Receipt from " + BusinessInfo.getInstance().getName(), invoiceEmail, true, location);
            File file = new File(fileName);
            file.deleteOnExit();
            emailBuilder.addAttachment(file);
            try {
                URL url;
                String logPath = BusinessInfo.getInstance().getLogo();
                if (!StringUtils.isEmpty((String)logPath) && (url = IconLoader.class.getResource(logPath)) != null) {
                    File bizLogo = new File(url.getFile());
                    emailBuilder.addAttachment(bizLogo);
                }
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Failed to attach business logo to email.", (Throwable)e);
            }
            success = this.nudgeUtil.sendEmail(emailBuilder.build());
        } else {
            SMS sms = new SMS();
            sms.setPhoneNumber(location);
            sms.setText("TEST");
            success = NudgeManager.getInstance().sendSMS(sms).isSuccessful();
        }
        if (success) {
            return Response.ok((Object)"[accepted]").build();
        }
        return Response.status((int)500).build();
    }

    private Account getAccountForRequest(PaTAccountRequest request) {
        Account account = null;
        if (request.getAccountId() != 0L) {
            OrderMate.LOG.info("P@T requests account id " + request.getAccountId());
            account = (Account)PersistenceManager.getByID((long)request.getAccountId(), Account.class);
        }
        return account;
    }

    private TableAccount findAccountForTableName(String tableGroup, String physicalTableName) {
        List accounts;
        String name = physicalTableName;
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.trim();
        ObjectQuery query = Query.select(TableAccount.class).linkUsing(TableAccount.Properties.TABLE, LogicalTable.Properties.ID).linkUsing(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE, PhysicalTable.Properties.ID).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(PhysicalTable.Properties.NAME, (Object)name).orderBy(Account.Properties.ID, false);
        if (!StringUtils.isEmpty((String)tableGroup)) {
            query.linkUsing(LogicalTable.Properties.TABLE_GROUP, TableGroup.Properties.ID).equals(TableGroup.Properties.NAME, (Object)tableGroup.trim());
        }
        if ((accounts = PersistenceManager.getObjectList(TableAccount.class, (String)query.toString())).size() == 1) {
            return (TableAccount)accounts.get(0);
        }
        if (accounts.size() > 1) {
            for (TableAccount account : accounts) {
                if (!name.equalsIgnoreCase(account.getTable().getPrimaryPhysicalTable().getName())) continue;
                return account;
            }
            for (TableAccount account : accounts) {
                String tableName = account.getTable().getPrimaryPhysicalTable().getName();
                if (tableName.contains(name)) {
                    return account;
                }
                if (!("%" + name + "%").equalsIgnoreCase(tableName)) continue;
                return account;
            }
        }
        return null;
    }

    private TableAccount findAccountForTableId(Long tableId) {
        if (tableId == null) {
            return null;
        }
        List accounts = PersistenceManager.getObjectList(TableAccount.class, (String)Query.select(TableAccount.class).linkUsing(TableAccount.Properties.TABLE, LogicalTable.Properties.ID).equals(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE, (Object)tableId).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).orderBy(Account.Properties.ID, false).toString());
        if (accounts.size() >= 1) {
            return (TableAccount)accounts.get(0);
        }
        return null;
    }

    private User determineUser(long userId) {
        if (userId == -396762457L) {
            return User.getSystemUser();
        }
        return (User)PersistenceManager.getByID((long)userId, User.class);
    }

    @Path(value="accountFeedback")
    @Produces(value={"application/json"})
    @GET
    public Response getAccountFeedback(@QueryParam(value="accountCode") long accountId) {
        List questions = PersistenceManager.getObjectList(FeedbackQuestion.class, (String)Query.select(FeedbackQuestion.class).equals(FeedbackQuestion.Properties.PAY_AT_TABLE, (Object)"1").active(FeedbackQuestion.class).orderBy(FeedbackQuestion.Properties.ID).toString());
        FeedBack feedback = new FeedBack();
        for (FeedbackQuestion question : questions) {
            if (!question.getAnswers().isEmpty()) {
                FBQuestion newQ = new FBQuestion();
                newQ.setId(question.getID().longValue());
                newQ.setQuestion(question.getQuestionText());
                for (FeedbackAnswer answer : question.getAnswers()) {
                    FBAnswer newA = new FBAnswer();
                    newA.setId(answer.getID().longValue());
                    newA.setNextQuestion(answer.getNextQuestion() != null ? answer.getNextQuestion().getID() : null);
                    newA.setSequence(answer.getSequence());
                    newA.setAnswer(answer.getAnswerText());
                    newQ.getAnswers().add(newA);
                }
                feedback.getQuestions().add(newQ);
                continue;
            }
            OrderMate.LOG.warn("Cannot send question without at least one answer");
        }
        return Response.ok((Object)new ObjectMarshaller().marshal((Object)feedback)).build();
    }

    @POST
    @Path(value="accountFeedback")
    public Response setAccountFeedback(@FormParam(value="accountId") long accountId, @FormParam(value="values") String responses) {
        Account account = (Account)PersistenceManager.getByID((long)accountId, Account.class);
        if (account == null) {
            OrderMate.LOG.warn("Couldn't set feedback for account " + accountId + " because no account");
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)new ObjectMarshaller().marshal((Object)"Failure")).build();
        }
        List pairs = StringUtils.splitToPairs((String)responses, (String)"=", (String)";");
        for (Pair pair : pairs) {
            FeedbackQuestion question = (FeedbackQuestion)PersistenceManager.getByID((long)Long.parseLong((String)pair.getKey()), FeedbackQuestion.class);
            FeedbackAnswer answer = (FeedbackAnswer)PersistenceManager.getByID((long)Long.parseLong((String)pair.getValue()), FeedbackAnswer.class);
            if (question == null || answer == null) continue;
            FeedbackResponse response = new FeedbackResponse(question, answer, account);
            response.save();
        }
        OrderMate.LOG.info("Received feedback for account " + accountId + " " + responses);
        return Response.ok((Object)new ObjectMarshaller().marshal((Object)"Success")).build();
    }

    private String getInvoiceEmail(ItemGroup itemGroup, User user) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<Object> docketParams = new ArrayList<Object>();
        docketParams.add(itemGroup);
        docketParams.add(1);
        docketParams.add(user);
        docketParams.add(ReceiptPrinterQueries.getReceiptPrintersForTerminal((Terminal)Terminal.getServerMateTerminal()));
        XmlDocket docket = GroovyDocket.getReceiptDocket(null);
        docket.setParams(docketParams);
        docket.setTemplate(DocketTemplate.getHighestTemplate((DocketTemplate.DocketType)DocketTemplate.DocketType.RECEIPT, (TriggerActivationContext)new TriggerActivationContext(new EventContext(Terminal.getServerMateTerminal(), user), itemGroup)));
        String receiptStr = docket.generateXml();
        XMLDocketScanner scanner = new XMLDocketScanner((PrintCommanderInterface)new HtmlReceiptCommander(100));
        return scanner.visitDocument(receiptStr, false);
    }
}

