/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.ping;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.ListUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;

@Path(value="")
public class ServermatePingResource {
    private static Logger logger;
    private static Writer writer;

    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public String pingStatus(@QueryParam(value="caller") String calledFrom) {
        OrderMate.LOG.info("Status called from " + calledFrom);
        BusinessInfo info = BusinessInfo.getInstance();
        StringBuilder SB = new StringBuilder(info.getName());
        SB.append(" ").append(info.getLocation()).append(" - Version:").append(OrderMate.OM_VERSION.toString());
        return SB.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="logs")
    @Produces(value={"text/plain"})
    public String pingLogs(@QueryParam(value="caller") String calledFrom, @QueryParam(value="command") String command) {
        Class<ServermatePingResource> clazz;
        if (logger == null) {
            clazz = ServermatePingResource.class;
            // MONITORENTER : servermate.servlets.ping.ServermatePingResource.class
            if (logger == null) {
                String logPattern = "%6p %d{dd MMM HH:mm:ss} [%t] %c %x %m%n";
                String baseDirectory = System.getProperty("log.root") + "htmlLogger" + File.separator;
                logger = OrderMateLog.createLogger((String)baseDirectory, (String)"HtmlLogger", (String)"%6p %d{dd MMM HH:mm:ss} [%t] %c %x %m%n");
            }
            // MONITOREXIT : clazz
        }
        if (command != null && command.equals("detach")) {
            clazz = ServermatePingResource.class;
            // MONITORENTER : servermate.servlets.ping.ServermatePingResource.class
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            Iterator iterator = loggerContext.getLoggers().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    logger = null;
                    writer = null;
                    // MONITOREXIT : clazz
                    return "Logs closed";
                }
                Logger l = (Logger)iterator.next();
                if (!logger.equals((Object)l)) continue;
                loggerContext.getLoggers().remove(l);
            }
        }
        OrderMate.LOG.info("Getting logs");
        try {
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    @GET
    @Path(value="addresses")
    @Produces(value={"text/plain"})
    public Response getLocalIPAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        for (InetAddress address : IPAddressUtils.getLocalAddresses()) {
            addresses.add(address.getHostAddress());
        }
        return Response.ok((Object)ListUtils.listToString(addresses, (String)",")).build();
    }
}

