/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.reporting;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import ordermate.OrderMate;
import ordermate.integration.jaxb.report.SMReport;
import ordermate.integration.jaxb.report.SMReportList;

final class SMReportCache {
    private final int TIMEOUT = 10;
    private final Semaphore talkingStick;
    private long lastMinorUpdate = 0L;
    private long lastFullUpdate = 0L;
    private long staleTime;
    private long rancidTime;
    private Map<String, SMReport> reportMap = new LinkedHashMap<String, SMReport>();

    SMReportCache() {
        this(30, 3600);
    }

    SMReportCache(int staleTime, int rancidTime) {
        this.staleTime = staleTime * 1000;
        this.rancidTime = rancidTime * 1000;
        this.talkingStick = new Semaphore(1);
    }

    boolean lock() {
        try {
            return this.talkingStick.tryAcquire(1, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.warn("Cannot acquire report cache talking stick after 10 seconds ");
            return false;
        }
    }

    synchronized void unlock() {
        this.talkingStick.release();
    }

    boolean isStale() {
        return System.currentTimeMillis() > this.lastMinorUpdate + this.staleTime;
    }

    boolean isRancid() {
        return System.currentTimeMillis() > this.lastFullUpdate + this.rancidTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSMReportList(SMReportList reports, boolean full) {
        Map<String, SMReport> map = this.reportMap;
        synchronized (map) {
            for (SMReport report : reports.getReports()) {
                this.reportMap.put(report.getProperty(), report);
            }
            this.lastMinorUpdate = System.currentTimeMillis();
            if (full) {
                this.lastFullUpdate = this.lastMinorUpdate;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateSMReportList(SMReportList reports) {
        Map<String, SMReport> map = this.reportMap;
        synchronized (map) {
            for (SMReport report : this.reportMap.values()) {
                reports.getReports().add(report);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Map<String, SMReport> map = this.reportMap;
        synchronized (map) {
            this.reportMap.clear();
        }
        this.lastMinorUpdate = Long.MAX_VALUE;
        this.lastFullUpdate = Long.MAX_VALUE;
    }
}

