/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.reporting.scheduling;

import java.util.HashSet;
import java.util.List;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigFilter;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.reports.maker.OMReportMakerFactory;
import ordermate.integration.jaxb.smreport.SMReportConfig;
import ordermate.integration.jaxb.smreport.SMReportFilter;
import ordermate.integration.jaxb.smreport.SMReportSchedule;

public class SMReportSchedulingService {
    public void validateReportSchedule(SMReportSchedule reportSchedule) throws ReportSchedulingException {
        SMReportConfig reportConfig = reportSchedule.getReportConfig();
        OMReportMakerFactory factory = OMReportMakerFactory.getInstance();
        HashSet reportTypes = new HashSet(factory.getTypes());
        if (reportConfig.getType() == null || reportConfig.getType().isEmpty() || !reportTypes.contains(reportConfig.getType())) {
            throw new ReportSchedulingException("Invalid type.");
        }
        if (reportConfig.getLabel() == null || reportConfig.getLabel().isEmpty()) {
            throw new ReportSchedulingException("Invalid label.");
        }
    }

    public ConfigurableReportMaker<?, ?> createMakerForType(String reportType) throws ReportSchedulingException {
        ConfigurableReportMaker maker = (ConfigurableReportMaker)OMReportMakerFactory.getInstance().createReportMaker(reportType);
        if (maker == null) {
            throw new ReportSchedulingException("No report can be made for " + reportType);
        }
        return maker;
    }

    public ReportConfig createReportConfig(SMReportConfig smReportConfig, ConfigurableReportMaker<?, ?> reportMaker) throws ReportSchedulingException {
        ReportConfig reportConfig = new ReportConfig(smReportConfig.getType(), smReportConfig.getLabel());
        reportMaker.setReportConfig(reportConfig);
        for (SMReportFilter smReportFilter : smReportConfig.getFilters()) {
            ReportConfigFilter filter = reportConfig.getFilter(smReportFilter.getLabel());
            if (filter != null) {
                filter.setSearchValue(smReportFilter.getValue());
                continue;
            }
            throw new ReportSchedulingException("Filter " + smReportFilter.getLabel() + " doesn't exist for " + smReportConfig.getLabel());
        }
        reportConfig.save();
        return reportConfig;
    }

    public ReportConfigSchedule createReportSchedule(ReportConfig reportConfig, String schedule, List<String> recipients) {
        ReportConfigSchedule reportConfigSchedule = new ReportConfigSchedule(reportConfig);
        reportConfigSchedule.setCronSchedule(schedule);
        reportConfigSchedule.setEmail(this.joinEmails(recipients));
        reportConfigSchedule.save();
        return reportConfigSchedule;
    }

    private String joinEmails(List<String> emailList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < emailList.size(); ++i) {
            String email = emailList.get(i);
            sb.append(email);
            if (i >= emailList.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static class ReportSchedulingException
    extends Exception {
        private String reason = "";

        public ReportSchedulingException(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

