/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.stock;

import java.io.IOException;
import java.util.Iterator;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.stock.StockItem;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.xml.serializers.stock.StockBarcodeSerializer;
import stockmate.xml.serializers.stock.StockItemSerializer;

public class ServermateStockItemSerializerV2
extends StockItemSerializer {
    public static final String LABEL = "label";
    public static final String DISPLAY_UNIT = "display_unit";
    public static final String OUTER_NAME = "outer";
    public static final String OUTER_QTY = "outer_qty";
    public static final String OUTER_CONTAINER = "outer_cont";
    public static final String INNER_CONTAINER = "inner_cont";
    public static final String INNER_QTY = "inner_qty";
    public static final String INNER_UNIT = "inner_unit";
    public static final String TAG_NAME = "item";
    private StockBarcodeSerializer barcodeSerializer = new StockBarcodeSerializer();

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        docSerializer.startTag(null, TAG_NAME);
        StockItem item = (StockItem)objectToSerialise;
        docSerializer.attribute(null, "id", item.intID() + "");
        docSerializer.attribute(null, LABEL, item.getLabel());
        this.addIfNotNull(docSerializer, OUTER_NAME, item.getOuterName());
        this.addIfNotNull(docSerializer, OUTER_QTY, String.valueOf(item.getOuterQuantity() * item.getPurchaseQty().doubleValue()));
        MeasureUnitContainer innerContainer = item.getDisplayMeasureUnitContainer();
        if (innerContainer != null) {
            this.addIfNotNull(docSerializer, INNER_CONTAINER, innerContainer.getMeasureContainer());
            this.addIfNotNull(docSerializer, INNER_QTY, innerContainer.getQuantityPerContainer());
            this.addIfNotNull(docSerializer, INNER_UNIT, innerContainer.getMeasureUnit());
        }
        Iterator it = item.getStockBarcodes().iterator();
        while (it.hasNext()) {
            this.barcodeSerializer.serializeToXML(docSerializer, it.next());
        }
        docSerializer.endTag(null, TAG_NAME);
    }

    private void addIfNotNull(KXmlSerializer docSerializer, String attribute, Object toAdd) throws IOException {
        if (toAdd != null) {
            docSerializer.attribute(null, attribute, String.valueOf(toAdd));
        }
    }
}

