/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.stock;

import au.com.ordermate.util.TimeLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.Data;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockTake;
import ordermate.xml.serializers.stock.DBStockTakeSerializer;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.stock.ServermateStockGroupSerializer;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.BarcodePrefixSerializer;
import stockmate.xml.serializers.stock.StockAreaSerializer;
import stockmate.xml.serializers.stock.StockSupplierSerializer;

class ServermateStockSerializer {
    private static final String ROOT = "stock_data";

    ServermateStockSerializer() {
    }

    public void serializeToXML(KXmlSerializer docSerializer) throws IOException, XmlPullParserException {
        TimeLogger logger = new TimeLogger("Stock ");
        logger.log("Start");
        docSerializer.startTag(null, ROOT);
        this.serializeList((XMLObjectSerializer)this.getAreaSerializer(), StockArea.getStockAreas(), docSerializer);
        logger.log("Areas");
        this.serializeList((XMLObjectSerializer)this.getSupplierSerializer(), StockSupplier.getSuppliers(), docSerializer);
        logger.log("Suppliers");
        this.serializeList((XMLObjectSerializer)this.getStockGroupSerializer(), StockGroup.getTopLevelStockGroups(), docSerializer);
        logger.log("Groups");
        StockTake take = StockTake.getLiveStockTake();
        if (take != null) {
            ArrayList<StockTake> stockTakes = new ArrayList<StockTake>();
            stockTakes.add(take);
            this.serializeList((XMLObjectSerializer)new DBStockTakeSerializer(), stockTakes, docSerializer);
            logger.log("Take " + take.getLabel());
        }
        this.serializeList((XMLObjectSerializer)new BarcodePrefixSerializer(), Data.database.getBarcodePrefixes(), docSerializer);
        docSerializer.endTag(null, ROOT);
        logger.log("End");
    }

    protected StockAreaSerializer getAreaSerializer() {
        return new StockAreaSerializer();
    }

    protected StockSupplierSerializer getSupplierSerializer() {
        return new StockSupplierSerializer();
    }

    protected ServermateStockGroupSerializer getStockGroupSerializer() {
        return new ServermateStockGroupSerializer();
    }

    private void serializeList(XMLObjectSerializer visitor, List objectList, KXmlSerializer docSerializer) throws XmlPullParserException, IOException {
        for (Object nextObject : objectList) {
            if (nextObject == null) continue;
            visitor.serializeToXML(docSerializer, nextObject);
        }
    }
}

