/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.visitors.BarcodePrefixParser;
import servermate.servlets.visitors.StockAreaParser;
import servermate.servlets.visitors.StockBarcodeVisitor;
import servermate.servlets.visitors.StockGroupParser;
import servermate.servlets.visitors.StockInvoiceParser;
import servermate.servlets.visitors.StockRequestParser;
import servermate.servlets.visitors.StockSupplierParser;
import servermate.servlets.visitors.StockTakeParser;
import servermate.servlets.visitors.XMLTreeVisitor;
import stockmate.xml.XMLObjectParser;

public class ServermateStockParser
implements XMLObjectParser {
    private Map<String, XMLTreeVisitor<?, ?>> parserMap = new HashMap();

    public ServermateStockParser() {
        this.putIntoMap(new StockRequestParser());
        this.putIntoMap(new StockGroupParser());
        this.putIntoMap(new StockAreaParser());
        this.putIntoMap(new StockSupplierParser());
        this.putIntoMap(new StockTakeParser());
        this.putIntoMap(new BarcodePrefixParser());
        this.putIntoMap(new StockInvoiceParser());
        this.putIntoMap(new StockBarcodeVisitor());
    }

    private void putIntoMap(XMLTreeVisitor visitor) {
        this.parserMap.put(visitor.getTagName(), visitor);
    }

    public String getTagName() {
        return "stock_data";
    }

    public void parseFromXML(KXmlParser docParser) throws XmlPullParserException, IOException {
        if (docParser.getEventType() == 0) {
            docParser.nextTag();
        }
        docParser.require(2, null, this.getTagName());
        docParser.nextTag();
        while (docParser.getEventType() != 3) {
            String name = docParser.getName();
            XMLTreeVisitor<?, ?> parser = this.parserMap.get(name);
            if (parser == null) {
                OrderMate.LOG.warn(name + " tag is not defined for stock parser");
                while (docParser.getEventType() != 3 && !name.equals(docParser.getName())) {
                    docParser.nextTag();
                }
                continue;
            }
            parser.visit(null, docParser);
            docParser.nextTag();
        }
        docParser.require(3, null, this.getTagName());
    }

    public String getTextualResponse() {
        StringBuilder SB = new StringBuilder();
        for (XMLTreeVisitor<?, ?> visitor : this.parserMap.values()) {
            String response = visitor.getReturnMessage();
            if (response != null && response.length() > 0) {
                SB.append(visitor.getTagName());
                SB.append(": ");
                SB.append(response);
                SB.append("\n");
            }
            visitor.clearTextualResponse();
        }
        OrderMate.LOG.info("Sendback=" + SB.toString());
        return SB.toString();
    }
}

