/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.IOException;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.stock.StockBarcode;
import ordermate.database.stock.StockItem;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.visitors.XMLTreeVisitor;

class StockBarcodeVisitor
extends XMLTreeVisitor<StockItem, StockBarcode> {
    StockBarcodeVisitor() {
    }

    public String getTagName() {
        return "barcode";
    }

    @Override
    protected List<XMLTreeVisitor<StockBarcode, ?>> createChildVisitors() {
        return null;
    }

    @Override
    protected StockBarcode parseXML(StockItem parentItem, KXmlParser docParser) throws IOException, XmlPullParserException {
        String code = docParser.getAttributeValue(null, "code");
        if (code == null) {
            this.doByNode(parentItem, docParser);
        } else {
            this.applyBarcode(code, docParser.getAttributeValue(null, "item"));
        }
        return null;
    }

    private void doByNode(StockItem parentItem, KXmlParser docParser) throws XmlPullParserException, IOException {
        docParser.nextTag();
        String barcode = null;
        String item = null;
        while (3 != docParser.getEventType()) {
            if ("item".equals(docParser.getName())) {
                item = docParser.nextText();
            } else if ("code".equals(docParser.getName())) {
                barcode = docParser.nextText();
            }
            if (barcode != null && item != null) break;
            docParser.nextToken();
        }
        this.applyBarcode(barcode, item);
    }

    private void applyBarcode(String barcode, String item) {
        if (barcode != null && item != null) {
            StockItem stockItem = null;
            try {
                stockItem = (StockItem)PersistenceManager.getByID((long)Long.parseLong(item), StockItem.class);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot find item " + item);
            }
            if (stockItem == null) {
                try {
                    stockItem = (StockItem)PersistenceManager.getByID((long)Long.parseLong(barcode), StockItem.class);
                    barcode = item;
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot find item " + barcode);
                }
            }
            if (stockItem != null) {
                stockItem.addBarcode(barcode);
                stockItem.save();
                OrderMate.LOG.info("Barcode " + barcode + " has been saved to StockItem: " + stockItem);
            } else {
                OrderMate.LOG.warn("Barcode " + barcode + " has not been saved for item " + item);
            }
        }
    }
}

