/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockSupplier;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.visitors.StockInvoiceEntryVisitor;
import servermate.servlets.visitors.XMLTreeVisitor;

class StockInvoiceParser
extends XMLTreeVisitor<Void, StockInvoice> {
    StockInvoiceParser() {
    }

    @Override
    protected void postVisit(Void parentObject, StockInvoice createdObject) {
        createdObject.save();
    }

    public String getTagName() {
        return "invoice";
    }

    @Override
    protected List<XMLTreeVisitor<StockInvoice, ?>> createChildVisitors() {
        ArrayList list = new ArrayList();
        list.add(new StockInvoiceEntryVisitor());
        return list;
    }

    @Override
    protected StockInvoice parseXML(Void parent, KXmlParser docParser) throws IOException, XmlPullParserException {
        long areaID = Long.parseLong(docParser.getAttributeValue(null, "area"));
        String number = docParser.getAttributeValue(null, "number");
        long supplierID = Long.parseLong(docParser.getAttributeValue(null, "supplier"));
        String type = docParser.getAttributeValue(null, "type");
        StockInvoice newInvoice = new StockInvoice();
        newInvoice.setStockArea((StockArea)PersistenceManager.getByID((long)areaID, StockArea.class));
        newInvoice.setSupplier((StockSupplier)PersistenceManager.getByID((long)supplierID, StockSupplier.class));
        newInvoice.setInvoiceNumber(number);
        newInvoice.setInvoiceType(type);
        return newInvoice;
    }
}

