/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.OperationFailedException;
import java.io.IOException;
import java.util.List;
import ordermate.database.stock.StockTake;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.visitors.XMLTreeVisitor;

class StockRequestParser
extends XMLTreeVisitor<Void, String> {
    private static final String TAG_NAME = "request";
    private static final String REQUEST_VALUE = "value";
    private static final String NEW_STOCKTAKE = "new stocktake";

    StockRequestParser() {
    }

    @Override
    protected List<XMLTreeVisitor<String, ?>> createChildVisitors() {
        return null;
    }

    @Override
    protected String parseXML(Void parent, KXmlParser docParser) throws IOException, XmlPullParserException {
        String request = docParser.getAttributeValue(null, REQUEST_VALUE);
        this.handleRequest(request);
        return request;
    }

    private void handleRequest(String request) {
        if (request != null) {
            if (request.equals(NEW_STOCKTAKE)) {
                if (StockTake.getLiveStockTake() == null) {
                    try {
                        StockTake.createStockTake();
                    }
                    catch (OperationFailedException ex) {
                        OrderMateLog.LOG.warn("Couldn't create a new StockTake", (Throwable)ex);
                    }
                }
            } else {
                OrderMateLog.LOG.warn(request + " is an unknown request for ServermateStockParser.");
            }
        }
    }

    public String getTagName() {
        return TAG_NAME;
    }
}

