/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import au.com.ordermate.persistence.PersistenceManager;
import java.io.IOException;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import servermate.servlets.visitors.XMLTreeVisitor;

class StockTakeEntryVisitor
extends XMLTreeVisitor<StockTake, StockTakeEntry> {
    private String entryId;
    private String areaId;
    private String itemId;
    private String qty;

    StockTakeEntryVisitor() {
    }

    public String getTagName() {
        return "entry";
    }

    @Override
    protected List<XMLTreeVisitor<StockTakeEntry, ?>> createChildVisitors() {
        return null;
    }

    @Override
    public void postVisit(StockTake parent, StockTakeEntry child) {
        if (parent != null && child != null) {
            if (!child.getStockTake().equals((Object)parent)) {
                throw new IllegalArgumentException("The given entry :" + child.intID() + " doesn't belong to the parent stockTake:" + parent.intID());
            }
            if (parent.isLive()) {
                child.saveChild();
            }
        }
        this.entryId = null;
        this.areaId = null;
        this.itemId = null;
        this.qty = null;
    }

    @Override
    protected StockTakeEntry parseXML(StockTake stocktake, KXmlParser docParser) throws IOException, XmlPullParserException {
        StockTakeEntry entry;
        boolean isByAttributes;
        if (stocktake == null) {
            return null;
        }
        this.entryId = docParser.getAttributeValue(null, "id");
        this.areaId = docParser.getAttributeValue(null, "area");
        this.itemId = docParser.getAttributeValue(null, "item");
        this.qty = docParser.getAttributeValue(null, "actual_qty");
        boolean bl = isByAttributes = this.entryId != null;
        if (!isByAttributes) {
            this.doAsXmlNodesRatherThanAttributes(docParser);
        }
        long areaID = Long.parseLong(this.areaId);
        long itemID = Long.parseLong(this.itemId);
        long entryID = Long.parseLong(this.entryId);
        String actual = this.qty;
        Double actualQty = null;
        if (actual != null && actual.length() > 0) {
            actualQty = Double.valueOf(actual);
        }
        if ((entry = (StockTakeEntry)PersistenceManager.getByID((long)entryID, StockTakeEntry.class)) == null || entry.getStockArea().intID() != areaID || entry.getStockItem().intID() != itemID) {
            throw new XmlPullParserException("Given entry ID, area and/or item don't match the recorded instance.");
        }
        if (actualQty != null) {
            double realValue = actualQty;
            double multiplier = entry.getStockItem().getDisplayMeasureUnitContainer().getMultiplier();
            realValue *= multiplier;
            StockItem item = entry.getStockItem();
            if (item.getOuterContainer() != null) {
                double outerMultiplier = item.getOuterQuantity() * multiplier;
                int outerValue = (int)(realValue / outerMultiplier);
                if (outerValue != 0) {
                    entry.setOuterQty(Double.valueOf((double)outerValue * outerMultiplier));
                    double unitValue = realValue - (double)outerValue * outerMultiplier;
                    if (unitValue != 0.0) {
                        entry.setUnitQty(Double.valueOf(unitValue));
                    }
                } else {
                    entry.setActualQuantity(new Quantity(entry.getExpectedQuantity().getMeasureUnit(), realValue, true));
                }
            } else {
                entry.setActualQuantity(new Quantity(entry.getExpectedQuantity().getMeasureUnit(), realValue, true));
            }
        }
        OrderMate.LOG.info("Received " + entry);
        return entry;
    }

    private void doAsXmlNodesRatherThanAttributes(KXmlParser docParser) {
        int count = 0;
        try {
            docParser.require(2, null, "entry");
            docParser.nextTag();
            while (docParser.getEventType() != 3 && count < 4) {
                String name = docParser.getName();
                String value = docParser.nextText();
                if (name.equals("id")) {
                    this.entryId = value;
                    ++count;
                } else if (name.equals("area")) {
                    this.areaId = value;
                    ++count;
                } else if (name.equals("item")) {
                    this.itemId = value;
                    ++count;
                } else if (name.equals("actual_qty")) {
                    this.qty = value;
                    ++count;
                }
                if (count >= 4) continue;
                docParser.nextTag();
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot parse stock data the other way", (Throwable)ex);
        }
    }
}

