/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.visitors;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.xml.XMLTaggedElement;

public abstract class XMLTreeVisitor<P, C>
implements XMLTaggedElement {
    private Map<String, XMLTreeVisitor<C, ?>> visitorMap;

    public XMLTreeVisitor() {
        List<XMLTreeVisitor<C, ?>> list = this.createChildVisitors();
        if (list != null && list.size() > 0) {
            this.visitorMap = new HashMap();
            for (XMLTreeVisitor<C, ?> next : list) {
                this.visitorMap.put(next.getTagName(), next);
            }
        }
    }

    protected abstract List<XMLTreeVisitor<C, ?>> createChildVisitors();

    public void visit(P parentObject, KXmlParser docParser) throws IOException, XmlPullParserException {
        docParser.require(2, null, this.getTagName());
        C createdObject = this.parseXML(parentObject, docParser);
        docParser.nextTag();
        if (this.visitorMap != null) {
            while (docParser.getEventType() != 3) {
                this.doChildVisit(createdObject, docParser);
                docParser.nextTag();
            }
        }
        docParser.require(3, null, this.getTagName());
        this.postVisit(parentObject, createdObject);
    }

    protected void doChildVisit(C createdObject, KXmlParser docParser) throws IOException, XmlPullParserException {
        String tagName = docParser.getName();
        XMLTreeVisitor<C, ?> visitor = this.visitorMap.get(tagName);
        if (visitor != null) {
            visitor.visit(createdObject, docParser);
        } else {
            OrderMate.LOG.warn(tagName + " is not known for the visitor " + this.getTagName());
            do {
                docParser.nextToken();
            } while (!tagName.equals(docParser.getName()) && docParser.getEventType() != 3);
        }
    }

    protected void postVisit(P parentObject, C createdObject) {
    }

    protected abstract C parseXML(P var1, KXmlParser var2) throws IOException, XmlPullParserException;

    public String getReturnMessage() {
        return null;
    }

    public void clearTextualResponse() {
    }
}

