/*
 * Decompiled with CFR 0.152.
 */
package servermate.servlets.webapp;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import com.vaadin.addon.touchkit.server.TouchKitServlet;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import ordermate.OrderMate;
import ordermate.database.integration.webpayment.WebPaymentIntegration;
import ordermate.database.integration.webpayment.WebPaymentLocation;
import ordermate.integration.paypal.remote.WebPaymentIntegrationQueries;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppSetupTask
extends AbstractTask {
    private static String resourceBase = "J:/";

    private boolean canRunTask() {
        List weblocs;
        boolean run = false;
        WebPaymentIntegration paypal = WebPaymentIntegrationQueries.getPayPalIntegration();
        if (paypal != null && (weblocs = paypal.getLocations()) != null && !weblocs.isEmpty()) {
            run = ((WebPaymentLocation)weblocs.get(0)).isPayTableOpen();
        }
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performTask() throws Exception {
        if (!this.canRunTask()) {
            OrderMate.LOG.info(this.getName() + " skipped : PayPal pay at table is not enabled!");
            return;
        }
        OrderMate.LOG.info("Setting up PayPal Servlet.");
        resourceBase = Config.getStringValue((String)"webapp-base");
        if (resourceBase == null || resourceBase.trim().isEmpty()) {
            resourceBase = "c:\\webapp";
        }
        String keystoreLocation = Config.getStringValue((String)"webapp-keystore");
        WebAppContext context = new WebAppContext();
        context.setContextPath("/");
        context.setResourceBase(resourceBase);
        TouchKitServlet servlet = new TouchKitServlet();
        ServletHolder vaadinLoader = new ServletHolder((Servlet)servlet);
        vaadinLoader.setInitParameter("session-timeout", "-1");
        vaadinLoader.setInitParameter("widgetset", "au.com.ordermate.touchkitwidgetset.widgetset.TouchkitwidgetsetWidgetset");
        if (!Config.isDebuging()) {
            vaadinLoader.setInitParameter("productionMode", "true");
        }
        context.addServlet(vaadinLoader, "/*");
        GzipFilter zippy = new GzipFilter();
        FilterHolder holder = new FilterHolder();
        holder.setFilter((Filter)zippy);
        context.addFilter(holder, "/*", EnumSet.allOf(DispatcherType.class));
        Server server = new Server(8998);
        KeyStore store = KeyStore.getInstance("JKS");
        if (keystoreLocation != null && !keystoreLocation.isEmpty()) {
            OrderMate.LOG.info("Loading key store from:" + keystoreLocation);
            File loc = new File(keystoreLocation);
            try (FileInputStream input = null;){
                input = new FileInputStream(loc);
                store.load(input, "OMPosman12".toCharArray());
            }
        } else {
            OrderMate.LOG.info("Loading key store from jar");
            store.load(((Object)((Object)this)).getClass().getResourceAsStream("omkeystore.ks"), "OMPosman12".toCharArray());
        }
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStore(store);
        sslContextFactory.setKeyStorePassword("OMPosman12");
        sslContextFactory.setSslKeyManagerFactoryAlgorithm("SunX509");
        sslContextFactory.setNeedClientAuth(false);
        SslSocketConnector sslConnector = new SslSocketConnector(sslContextFactory);
        sslConnector.setPort(8999);
        sslConnector.setPassword("OMPosman12");
        server.addConnector((Connector)sslConnector);
        server.setHandler((Handler)context);
        server.start();
    }

    public String getName() {
        return "Setting up PayPal task";
    }

    protected int getTotalSubTasks() {
        return 2;
    }
}

