/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.Remote;
import java.sql.ResultSet;
import java.sql.SQLException;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.database.Data;
import ordermate.database.DatabaseService;
import ordermate.dbconnection.AbstractDatabaseConnection;
import servermate.ServerMate;
import servermate.security.ServermateSecurityManager;

public class ConstructDatabaseServiceTask
extends AbstractTask {
    private boolean share;
    private DBConnectionInterface dbCon;

    public ConstructDatabaseServiceTask(boolean shareOverRMI) {
        this.share = shareOverRMI;
    }

    public void setDBConnection(DBConnectionInterface connection) {
        this.dbCon = connection;
    }

    public int getTotalSubTasks() {
        return 3;
    }

    public String getName() {
        return "Constructing DatabaseService";
    }

    protected final void performTask() throws Exception {
        if (this.dbCon == null) {
            this.dbCon = AbstractDatabaseConnection.getDBConnectionInterface();
        }
        DbPinger pinger = new DbPinger(this.dbCon);
        new Thread((Runnable)pinger, "DBS DB Pinger").start();
        DatabaseService databaseService = new DatabaseService(this.dbCon);
        this.emitProgress();
        if (this.share) {
            SimpleRMI.shareObject((Remote)databaseService, (String)"DatabaseService");
        }
        Data.setup((DatabaseService)databaseService);
        this.emitProgress();
    }

    private static class DbPinger
    implements Runnable {
        private static final int SLEEP_TIME = 900000;
        private DBConnectionInterface db;

        public DbPinger(DBConnectionInterface theDb) {
            this.db = theDb;
        }

        @Override
        public void run() {
            while (true) {
                ResultSet rs = null;
                try {
                    Thread.sleep(900000L);
                    rs = this.db.executeQuery("SELECT 1");
                    if (!rs.next() || !PersistenceManager.isPersistenceSetup()) continue;
                    ServermateSecurityManager.start();
                    continue;
                }
                catch (Exception e) {
                    ServerMate.LOG.warn("Error in DbPinger", (Throwable)e);
                    continue;
                }
                finally {
                    try {
                        if (rs == null) continue;
                        this.db.release(rs);
                    }
                    catch (SQLException ex) {
                        OrderMate.LOG.info("Exception closing connection", (Throwable)ex);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

