/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.persistence.PersistenceManager;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.integrity.InventoryItemUnitStockCountCheck;
import ordermate.scheduler.Task;
import servermate.ServerMate;
import servermate.integrity.DeliveryAccountCustomerCheck;
import servermate.integrity.DeliveryTriggerCheck;
import servermate.integrity.FinanceTimesheetsHaveValidTimeInOutCheck;
import servermate.integrity.InventoryItemCheck;
import servermate.integrity.ReferencesCheck;
import servermate.integrity.SalesPriceAdjustmentCheck;

public class DatabaseIntegrityCheckTask
implements Task {
    public static final String NAME = "Database Integrity Check";
    private static Semaphore talkingStick = new Semaphore(1);
    private DefaultTrigger dftTrigger = null;
    private final TaskInterrupter taskInterrupter;

    public DatabaseIntegrityCheckTask(TaskInterrupter interrupter) {
        this.taskInterrupter = interrupter;
    }

    public void run() {
        if (talkingStick.tryAcquire()) {
            try {
                this.performTask();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot do database integrity check", (Throwable)ex);
            }
            talkingStick.release();
        } else {
            OrderMate.LOG.warn("database integrity check already/still synchronizing, will not repeat.");
        }
    }

    public String getName() {
        return NAME;
    }

    public void setData(Object data) {
    }

    private void performTask() {
        block13: {
            this.checkProcedures();
            for (AbstractTrigger toCheck : AbstractTrigger.getAllTriggers()) {
                if (!(toCheck instanceof DefaultTrigger)) continue;
                this.dftTrigger = (DefaultTrigger)toCheck;
            }
            try {
                this.checkDocket(DocketTemplate.DocketType.PREP_DOCKET);
                this.checkDocket(DocketTemplate.DocketType.RECEIPT);
                this.checkDocket(DocketTemplate.DocketType.TAKINGS_DOCKET);
                this.checkCourses();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkSalesAdjustments();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkStockCounts();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkItemSetup();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkReferences();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkDeliveryFee();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkDeliveryTrigger();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkDeliveryAccountsHaveCustomer();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkStockItemsAssignedToStockGroups();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
                this.checkFinanceTimesheetsHaveValidTimeInOut();
                if (this.taskInterrupter.isInterrupt()) {
                    return;
                }
            }
            catch (Exception e) {
                ServerMate.LOG.error((Object)e);
                String msg = "Database integrity check failed.\n" + e.getLocalizedMessage() == null ? e.toString() : e.getLocalizedMessage();
                int choice = JOptionPane.showConfirmDialog(null, msg, "Do you want to continue?", 0, 0);
                if (choice != 1) break block13;
                ServerMate.exit(-1);
            }
        }
    }

    private void checkProcedures() {
        PersistenceManager.getPersistenceDelegate().executeUpdate("REPAIR TABLE mysql.proc", new Object[0]);
    }

    private void checkStockItemsAssignedToStockGroups() {
        List unassignedStockItems = StockItemQueries.getStockItemsWithoutStockGroup();
        if (!unassignedStockItems.isEmpty()) {
            StockGroup unassignedGroup = StockGroup.getUnassignedStockGroup();
            for (StockItem item : unassignedStockItems) {
                item.setStockGroup(unassignedGroup);
                item.save();
            }
        }
    }

    private void checkDeliveryFee() {
        if (SystemProperty.getInstance().getDeliveryFee() == null) {
            OrderMate.LOG.warn("Could not find delivery fee, creating a new one for zero dollars.");
            SystemProperty.getInstance().createMissingDeliveryFee();
            SystemProperty.getInstance().save();
        }
    }

    private void checkSalesAdjustments() {
        try {
            new SalesPriceAdjustmentCheck().check();
        }
        catch (SQLException e) {
            ServerMate.LOG.error((Object)e);
        }
    }

    private void checkCourses() {
        if (Course.getCourses().size() == 0) {
            Course newCourse = new Course();
            newCourse.setName("Main");
            newCourse.save();
            ServerMate.LOG.warn("Cannot find a course, created a new one.");
        }
        if (Course.getDefault() == null) {
            Course newDefault = (Course)Course.getCourses().get(0);
            newDefault.isDefaultCourse();
            newDefault.save();
            ServerMate.LOG.warn("Cannot find a default course, assigned a new one.");
        }
    }

    private void checkDocket(DocketTemplate.DocketType type) {
        List templates = DocketTemplate.getTemplatesByType((DocketTemplate.DocketType)type);
        if (templates.isEmpty()) {
            if (this.dftTrigger == null) {
                this.dftTrigger = new DefaultTrigger();
                this.dftTrigger.setLabel("Default");
                this.dftTrigger.save();
            }
            DocketTemplate template = new DocketTemplate(type);
            template.setTemplateName(type.toString());
            template.addTrigger((AbstractTrigger)this.dftTrigger);
            template.save();
        }
    }

    private void checkStockCounts() {
        if (SystemProperty.getInstance().isStockCountDownEnabled()) {
            new InventoryItemUnitStockCountCheck().check();
        }
    }

    private void checkItemSetup() {
        new InventoryItemCheck().check();
    }

    private void checkReferences() {
        if (!Config.getBooleanValue((String)"disable_sync")) {
            new ReferencesCheck(this.taskInterrupter).check();
        }
    }

    private void checkDeliveryTrigger() {
        new DeliveryTriggerCheck().check();
    }

    private void checkDeliveryAccountsHaveCustomer() {
        new DeliveryAccountCustomerCheck().check();
    }

    private void checkFinanceTimesheetsHaveValidTimeInOut() {
        new FinanceTimesheetsHaveValidTimeInOutCheck().check();
    }
}

