/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.integration.online.PrintOnlyOnlineTerminalConfiguration;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.docketprocessor.ExternalPrintJob;
import servermate.ServerMate;

public class MenuLogIntegrationTask
extends TimerTask {
    private int runs = 0;
    private static final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String name) {
            return name.endsWith(".xml");
        }
    };

    @Override
    public void run() {
        try {
            for (PrintOnlyOnlineTerminalConfiguration menulogConfig : PrintOnlyOnlineTerminalConfiguration.getConfigurations()) {
                if (!"ACTIVE".equals(menulogConfig.getSystemState())) continue;
                VirtualPrinter printer = menulogConfig.getVirtualPrinter();
                String docketsFolderName = menulogConfig.getFilePath();
                if (Config.isDebuging() && ++this.runs == 300) {
                    OrderMate.LOG.info("Scanning " + docketsFolderName + " for incoming online dockets (shown only every 10 mins)");
                    this.runs = 0;
                }
                this.printDocketsFromFolder(docketsFolderName, printer);
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error occurred in MenuLogIntegrationTask", (Throwable)e);
        }
    }

    public void printDocketsFromFolder(String docketsFolderName, VirtualPrinter printer) {
        File folder = new File(docketsFolderName);
        if (folder.isDirectory()) {
            File[] files;
            for (File file : files = folder.listFiles(filter)) {
                String xmlDocket;
                if (Config.isDebuging()) {
                    OrderMate.LOG.info("Processing docket " + file.getName());
                }
                if ((xmlDocket = MenuLogIntegrationTask.getXMLFileAsString(file)) == null || "".equals(xmlDocket)) continue;
                try {
                    ExternalPrintJob job = new ExternalPrintJob(xmlDocket, printer);
                    DocketProcessor.printExternalDocket((ExternalPrintJob)job);
                    if (!Config.isDebuging()) continue;
                    OrderMate.LOG.info("Finished processing docket " + file.getName());
                }
                catch (IOException e) {
                    ServerMate.LOG.error("An error occurred trying to print external docket", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXMLFileAsString(File docket) {
        StringBuffer buffer = new StringBuffer();
        FileInputStream reader = null;
        BufferedReader bufReader = null;
        InputStreamReader inReader = null;
        try {
            reader = new FileInputStream(docket);
            inReader = new InputStreamReader((InputStream)reader, "UTF-8");
            bufReader = new BufferedReader(inReader);
            String line = bufReader.readLine();
            while (line != null) {
                buffer.append(line);
                line = bufReader.readLine();
            }
        }
        catch (FileNotFoundException fne) {
            String string = "";
            return string;
        }
        catch (IOException ioe) {
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (inReader != null) {
                        ((Reader)inReader).close();
                    }
                    reader.close();
                }
                catch (IOException e) {
                    ServerMate.LOG.error("Unable to close reader", (Throwable)e);
                }
                if (docket != null && !docket.delete()) {
                    ServerMate.LOG.error("Unable to delete docket " + docket.getName());
                }
            }
        }
        return buffer.toString();
    }
}

