/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import ordermate.OrderMate;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.integration.onlinesales.OnlineAccountIntegrator;
import ordermate.webresource.online.OnlineOrderErrorExporter;

public class OnlineIntegrationFileWatchTask
extends TimerTask {
    private static final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String name) {
            return name.endsWith(".xml");
        }
    };
    private OnlineIntegrationConfig config = OnlineIntegrationConfig.getDefaultInstance();
    private OnlineOrderErrorExporter failureXmlExporter;
    private OnlineAccountIntegrator integrator = new OnlineAccountIntegrator();

    @Override
    public void run() {
        try {
            File[] files;
            OnlineIntegrationConfig newConfig = OnlineIntegrationConfig.getDefaultInstance();
            if (this.config == null || !this.config.equals((Object)newConfig)) {
                this.integrator = new OnlineAccountIntegrator();
            }
            this.config = newConfig;
            String directoryPath = this.config.getFileWatcherPath();
            if (StringUtils.isEmpty((String)directoryPath)) {
                return;
            }
            for (File file : files = this.getFiles(directoryPath)) {
                InputStream stream = null;
                try {
                    stream = new BufferedInputStream(new FileInputStream(file));
                    this.integrator.process(stream);
                }
                catch (Exception ex) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception ex1) {
                        OrderMate.LOG.warn("Error closing stream", (Throwable)ex);
                    }
                    OrderMate.LOG.error("Error processing incoming file : " + file, (Throwable)ex);
                    this.moveFileToFail(file, ex);
                    this.buildAndSaveExportErrorFile(file.getParent() + "/fail", file.getName(), ex);
                    continue;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.info("Error closing stream", (Throwable)ex);
                    }
                }
                this.moveFileToSucess(file);
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error occurred in OnlineIntegrationFileWatcherTask", (Throwable)e);
        }
    }

    private OnlineOrderErrorExporter getOnlineOrderErrorExporter() throws DatatypeConfigurationException {
        if (this.failureXmlExporter == null) {
            this.failureXmlExporter = new OnlineOrderErrorExporter();
        }
        return this.failureXmlExporter;
    }

    private void moveFileToSucess(File toMove) {
        boolean success;
        File successDestination = new File(toMove.getParent() + "/success");
        if (!successDestination.exists()) {
            successDestination.mkdir();
        }
        if (!(success = toMove.renameTo(new File(successDestination, toMove.getName())))) {
            OrderMate.LOG.error("Could not move file to success" + toMove + " will attempt to delete");
            if (toMove.delete()) {
                OrderMate.LOG.warn("Successfully deleted :" + toMove);
            } else {
                OrderMate.LOG.error("Could not delete file :" + toMove + ", this will lead to multiple orders being process for this imported sale");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildAndSaveExportErrorFile(String fileAndpath, String fileName, Exception ex) {
        boolean result = false;
        String XMLErrorPathAndFileName = fileAndpath;
        fileName = fileName.replace(".xml", "_err.xml");
        XMLErrorPathAndFileName = XMLErrorPathAndFileName + "/" + fileName;
        FileOutputStream outputXmlErrorFile = null;
        try {
            outputXmlErrorFile = new FileOutputStream(XMLErrorPathAndFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            OrderMate.LOG.error("error while trying to build error XML file for Online order...");
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                if (outputXmlErrorFile != null) {
                    outputXmlErrorFile.flush();
                    outputXmlErrorFile.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (outputXmlErrorFile != null) {
            this.exportErrorXMLFile(outputXmlErrorFile, ex);
            result = true;
        }
        return result;
    }

    private void exportErrorXMLFile(FileOutputStream outputStream, Exception e) {
        try {
            this.getOnlineOrderErrorExporter().exportFailedOnlineOrder(e, outputStream);
        }
        catch (JAXBException e1) {
            e1.printStackTrace();
        }
        catch (DatatypeConfigurationException e1) {
            e1.printStackTrace();
            OrderMate.LOG.error("error while trying to build error XML file for Online order...");
        }
    }

    private void moveFileToFail(File toMove, Exception ex) {
        boolean success;
        File failDestination = new File(toMove.getParent() + "/fail");
        if (!failDestination.exists()) {
            failDestination.mkdir();
        }
        if (!(success = toMove.renameTo(new File(failDestination, toMove.getName() + "-fail" + System.currentTimeMillis() / 1000L)))) {
            OrderMate.LOG.error("Could not move file to failure " + toMove + " deleting");
        }
    }

    private File[] getFiles(String path) {
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory()) {
            return directory.listFiles(filter);
        }
        if (!path.isEmpty() && !directory.mkdirs()) {
            OrderMate.LOG.warn(path + " does not exist or is not a directory. Exists? " + directory.exists());
        }
        return new File[0];
    }
}

