/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.misc.SystemProperty;
import ordermate.database.schedule.Schedule;

public class ScheduleDBIntegrityCheckStartupTask
extends AbstractTask {
    private final TaskInterrupter taskInterrupter;

    public ScheduleDBIntegrityCheckStartupTask(TaskInterrupter interrupter) {
        this.taskInterrupter = interrupter;
    }

    public String getName() {
        return "Scheduling Database Integrity Check";
    }

    public static Schedule getDBIntegrityCheckSchedule() {
        SystemProperty property;
        String cron;
        Schedule schedule = (Schedule)PersistenceManager.getObject(Schedule.class, (String)Query.select(Schedule.class).equals(Schedule.Properties.TASK, (Object)"Database Integrity Check").toString());
        if (schedule == null) {
            schedule = new Schedule();
            schedule.setTask("Database Integrity Check");
            schedule.setLabel("Database Integrity Check");
            schedule.setRecurrence("");
        }
        if (StringUtils.isEmpty((String)schedule.getRecurrence()) && (cron = (property = SystemProperty.getInstance()).getDbCheckSchedule()) != null && !cron.trim().isEmpty()) {
            schedule.setRecurrence(cron);
        }
        return schedule;
    }

    protected void performTask() throws Exception {
        if (!Config.getBooleanValue((String)"disable_sync")) {
            Schedule schedule = ScheduleDBIntegrityCheckStartupTask.getDBIntegrityCheckSchedule();
            schedule.setSystemState(SystemState.ACTIVE_STATE);
            schedule.save();
        } else {
            Schedule schedule = (Schedule)PersistenceManager.getObject(Schedule.class, (String)Query.select(Schedule.class).equals(Schedule.Properties.TASK, (Object)"Database Integrity Check").toString());
            if (schedule != null) {
                schedule.setSystemState(SystemState.DELETED_STATE);
                schedule.save();
            }
        }
    }

    protected int getTotalSubTasks() {
        return 1;
    }
}

