/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.ProcessUtil;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.ServermateEventLog;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemVersionHistory;
import ordermate.database.misc.application.ApplicationConfig;
import ordermate.jnlp.CreateJNLPExecutable;

public class SystemVersionHistoryUpdateTask
extends AbstractTask {
    public String getName() {
        return "Updating System Version History";
    }

    protected void performTask() throws Exception {
        SystemCurrentInfo info;
        boolean isUpdated = false;
        if (!this.currentVersionExists()) {
            SystemVersionHistory versionHistory = new SystemVersionHistory();
            versionHistory.save();
            ServermateEventLog.getInst().logSystemVersionUpdate(versionHistory);
            isUpdated = true;
        }
        if (!OrderMate.VERSION.equals((info = SystemCurrentInfo.getInstance()).getCurrentVersion())) {
            isUpdated = true;
            OrderMate.LOG.info("Setting version to " + OrderMate.VERSION);
            info.setCurrentVersion(OrderMate.VERSION);
            info.save();
        }
        if (isUpdated) {
            try {
                OrderMate.LOG.info("Calling JNLP Builder");
                List configList = PersistenceManager.getObjectList(ApplicationConfig.class, (String)Query.select(ApplicationConfig.class).toString());
                ApplicationConfig[] configs = configList.toArray(new ApplicationConfig[configList.size()]);
                new CreateJNLPExecutable(configs, true).execute();
                try {
                    if (Config.isDebuging()) {
                        return;
                    }
                    OrderMate.LOG.info("Restarting Servermate ... ");
                    ProcessUtil.restartService((String)"ServerMateService");
                }
                catch (Exception e) {
                    OrderMate.LOG.error("Failed to restart ServerMateService: ", (Throwable)e);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Couldn't run the application JNLP builder", (Throwable)ex);
            }
        } else {
            OrderMate.LOG.info("Not calling JNLP Builder");
        }
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    protected boolean currentVersionExists() {
        SystemVersionHistory versionHistory = (SystemVersionHistory)PersistenceManager.getObject(SystemVersionHistory.class, (String)Query.select(SystemVersionHistory.class).equals(SystemVersionHistory.Properties.VERSION_STRING, (Object)OrderMate.VERSION.toString()).toString());
        return versionHistory != null;
    }
}

