/*
 * Decompiled with CFR 0.152.
 */
package servermate.startup.scheduledtasks;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.TaskInterrupter;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.ClosePaidUnallocatedTableTask;
import ordermate.database.sales.customer.external.ImportCustomersFromMemberJungleTask;
import ordermate.database.sales.customer.external.ImportExternalCustomerTask;
import ordermate.hom.synchronisation.customer.FullCustomerUpdateTask;
import ordermate.integration.automatedsalesandvariance.AutomatedExportTask;
import ordermate.integration.finance.AccountingIntegrationExportTask;
import ordermate.integration.finance.RetryExportTask;
import ordermate.integration.liquorfile.scandata.ScandataExportTask;
import ordermate.integration.storegroup.StoreGroupMonthlyReportLoader;
import ordermate.integration.storegroup.StoreGroupMonthlySaleTask;
import ordermate.integration.storegroup.eftpos.DailyEftposDetailedReportTask;
import ordermate.integration.storegroup.eftpos.EftposSummaryReportTask;
import ordermate.integration.storegroup.eftpos.MonthlyEftposDetailedReportTask;
import ordermate.integration.storegroup.eftpos.WeeklyEftposDetailedReportTask;
import ordermate.reports.email.EmailReportTask;
import ordermate.scheduler.Task;
import ordermate.scheduler.TaskCreationStrategy;
import ordermate.scheduler.TaskFactory;
import ordermate.startup.CustomerStatsUpdateTask;
import ordermate.startup.DatabaseBackupTask;
import ordermate.startup.HumpBackSyncUnknownsTask;
import ordermate.startup.LocalUserLogoutTask;
import ordermate.startup.PushDiamondSummaryReportTask;
import ordermate.startup.ResetStockCountdownTask;
import ordermate.startup.RestartTerminalsTask;
import ordermate.startup.XeroTokenRefreshTask;
import servermate.startup.DatabaseIntegrityCheckTask;

public class RegisterScheduledTask
extends AbstractTask {
    protected void performTask() throws Exception {
        this.registerAllTasks();
    }

    public String getName() {
        return "Register scheduled tasks";
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    private void registerAllTasks() {
        TaskFactory.initialize();
        TaskFactory.registerTask((Task)new StoreGroupMonthlySaleTask());
        TaskFactory.registerTask((Task)new StoreGroupMonthlyReportLoader());
        TaskFactory.registerTask((Task)new AutomatedExportTask());
        if (SystemProperty.getInstance().isLiquorfileEnabled() && PersistentLicenseManager.getInstance().getBoolean(LicenseType.LiquorfileIntegrationEnabled)) {
            TaskFactory.registerTask((Task)new ScandataExportTask());
        }
        TaskFactory.registerTask((Task)new EftposSummaryReportTask());
        TaskFactory.registerTask((Task)new DailyEftposDetailedReportTask());
        TaskFactory.registerTask((Task)new WeeklyEftposDetailedReportTask());
        TaskFactory.registerTask((Task)new MonthlyEftposDetailedReportTask());
        TaskFactory.registerTask((Task)new FullCustomerUpdateTask());
        TaskFactory.registerTask((Task)new AccountingIntegrationExportTask());
        TaskFactory.registerTask((Task)new EmailReportTask(), (TaskCreationStrategy)TaskCreationStrategy.NewInstance);
        TaskFactory.registerTask((Task)new RestartTerminalsTask());
        TaskFactory.registerTask((Task)new HumpBackSyncUnknownsTask());
        TaskFactory.registerTask((Task)new ImportExternalCustomerTask());
        TaskFactory.registerTask((Task)new ImportCustomersFromMemberJungleTask());
        TaskFactory.registerTask((Task)new CustomerStatsUpdateTask());
        TaskFactory.registerTask((Task)new DatabaseBackupTask());
        TaskFactory.registerTask((Task)new LocalUserLogoutTask());
        TaskFactory.registerTask((Task)new ResetStockCountdownTask());
        TaskFactory.registerTask((Task)new DatabaseIntegrityCheckTask(new TaskInterrupter("Skip database check")));
        TaskFactory.registerTask((Task)new RetryExportTask());
        TaskFactory.registerTask((Task)new XeroTokenRefreshTask());
        TaskFactory.registerTask((Task)new ClosePaidUnallocatedTableTask());
        TaskFactory.registerTask((Task)new PushDiamondSummaryReportTask());
    }
}

