/*
 * Decompiled with CFR 0.152.
 */
package servermate.client;

import au.com.ordermate.OMLogUtil;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.Task;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import ordermate.OrderMate;
import ordermate.serverconnection.ConnectionChecker;
import ordermate.serverconnection.ConnectionCheckerStrategy;
import ordermate.serverconnection.ConnectionManagerScreen;
import ordermate.serverconnection.ServerConnectionManager;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.ServerConnectionSetupTask;
import org.apache.logging.log4j.core.Logger;
import servermate.client.ServerMateClientEndPoint;
import servermate.client.ServermateStandaloneEndpointCheckStrategy;
import servermate.client.gui.ServerMateClientGUI;
import servermate.client.standalone.SMClientFinishTask;
import servermate.client.standalone.ServermateClientStandaloneEndPointTask;
import servermate.client.startup.ConnectToServerMateTask;
import servermate.client.startup.ConstructGuiTask;
import servermate.events.ReconnectToServerDelegate;

public class ServerMateClient {
    private ServerSocket socket = null;
    public static final String MODULE_NAME = "ServerMateClient";
    public static final Logger LOG = ServerMateClient.createLogger();
    private static ReconnectToServerDelegate eventDelegate = new ReconnectToServerDelegate();

    private static Logger createLogger() {
        String user = System.getProperty("user.name");
        String identifier = "ServerMateClient-" + user;
        return OMLogUtil.createRootLoggerWithParentDirectory((String)OMLogUtil.getServermateClientParentFolder(), (String)identifier);
    }

    public static void main(String ... args) throws Exception {
        System.setProperty("Driver", "com.sun.comm.Win32Driver");
        ServerMateClient serverMateClient = new ServerMateClient();
        LOG.info("Starting Servermate Client " + OrderMate.VERSION);
        ServerMateClient.runLocalTask((AbstractTask)new ConfigurationTask("ServermateClientConfig.ini"), false);
        if (ServerMateClient.checkForUniqueness(serverMateClient)) {
            ServerMateClientEndPoint.getClient();
            ServerConnectionManager.reconnectSignal.connect((Object)eventDelegate, "reconnectToServer");
            CompositeTask startup = new CompositeTask("Starting ServerMate Client");
            startup.setRunOnce(false);
            startup.addTask((Task)new ConstructGuiTask());
            startup.addTask((Task)new ServermateClientStandaloneEndPointTask());
            startup.addTask((Task)new ConnectToServerMateTask(false));
            startup.addTask((Task)new SMClientFinishTask());
            ServerConnectionSetupTask connectionTask = new ServerConnectionSetupTask(ServerMateClientGUI.class, "ServerMate", null);
            ConnectionChecker.setStrategy((ConnectionCheckerStrategy)new ServermateStandaloneEndpointCheckStrategy());
            connectionTask.setScreen((ConnectionManagerScreen)ServerMateClientGUI.getInstance());
            startup.addTask((Task)connectionTask);
            serverMateClient.startUpScreen(startup);
        }
    }

    private void startUpScreen(CompositeTask startup) {
        try {
            startup.runLocal();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void runLocalTask(AbstractTask task, boolean inThread) {
        try {
            if (!inThread) {
                task.runLocal();
            } else {
                Thread thread = new Thread((Runnable)task);
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static boolean checkForUniqueness(ServerMateClient serverMateClient) throws Exception {
        try {
            serverMateClient.socket = new ServerSocket();
            serverMateClient.socket.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 48209));
            LOG.info("Claiming Servermate client socket 48209");
            return serverMateClient.socket.isBound();
        }
        catch (Exception ex) {
            LOG.warn("Problem while checking for existing client", (Throwable)ex);
            LOG.warn("Existing Servermate Client: Exiting");
            return false;
        }
    }
}

