/*
 * Decompiled with CFR 0.152.
 */
package servermate.client.gui;

import au.com.ordermate.configuration.Config;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ordermate.serverconnection.ConnectionManagerScreen;
import servermate.client.ServerMateClient;
import servermate.client.standalone.TaskBarMessage;

public class ServerMateClientGUI
implements ConnectionManagerScreen {
    private JOptionPane optionPane;
    private JDialog messageDialog = null;
    private final int MESSAGE_DISPLAY_FREQUENCY = 5;
    private int messageDisplayCounter = 0;
    private static ServerMateClientGUI instance;

    public static ServerMateClientGUI getInstance() {
        if (instance == null) {
            instance = new ServerMateClientGUI();
        }
        return instance;
    }

    private ServerMateClientGUI() {
    }

    private void createMessageDialog(String message, String title) {
        if (this.messageDialog == null) {
            this.optionPane = new JOptionPane(message, 0);
            this.messageDialog = this.optionPane.createDialog(title);
        }
        this.optionPane.setMessage(message);
        this.optionPane.setMessageType(2);
        this.messageDialog.setTitle(title);
        this.optionPane.revalidate();
        this.messageDialog.pack();
    }

    protected String getHostServerName() {
        return Config.getStringValue((String)"app_server");
    }

    private String detectServermateUnreachableProblem() {
        String servermateHostName = this.getHostServerName();
        try {
            Process p1 = Runtime.getRuntime().exec("ping -n 1 " + servermateHostName);
            int returnVal = p1.waitFor();
            if (returnVal == 0) {
                return "Please check whether Servermate is running";
            }
        }
        catch (IOException e) {
            ServerMateClient.LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            ServerMateClient.LOG.error(e.getMessage(), (Throwable)e);
        }
        return "Could not reach Servermate.  Please check whether value for app_server is correct in ServermateClientConfig.ini";
    }

    public void showConnectionInterface() {
        String reason = this.detectServermateUnreachableProblem();
        if ("Could not reach Servermate.  Please check whether value for app_server is correct in ServermateClientConfig.ini".equalsIgnoreCase(reason)) {
            this.showMessageDialog(reason, "Error");
        } else if ("Please check whether Servermate is running".equalsIgnoreCase(reason)) {
            this.showMessageDialog(reason, "Warning");
        }
    }

    public void showMessageDialog(final String reason, final String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doShowMessage(reason, title);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerMateClientGUI.this.doShowMessage(reason, title);
                }
            });
        }
    }

    private void doShowMessage(String reason, String title) {
        this.createMessageDialog(reason, title);
        if (!this.messageDialog.isVisible()) {
            this.messageDialog.setVisible(true);
        }
    }

    public void hideConnectionInterface() {
        if (this.messageDialog != null) {
            this.messageDialog.setVisible(false);
        }
    }

    public void setNumRetries(String server, int numRetries) {
        this.showMessageInTaskBar();
    }

    private void showMessageInTaskBar() {
        if (++this.messageDisplayCounter > 5) {
            TaskBarMessage.showError("Unable to connect to Servermate.  Please check if Servermate is running");
            this.messageDisplayCounter = 0;
        }
    }

    public void displayVersionWarningDialog(String serverVersion) {
    }

    public void connectedToServer(boolean isRedundant, String serverIp) {
        if (this.messageDialog != null) {
            this.messageDialog.setVisible(false);
        }
    }
}

