/*
 * Decompiled with CFR 0.152.
 */
package servermate.client.rmi;

import au.com.ordermate.guicore.task.TaskInterrupter;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.util.IPAddressUtils;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.misc.OrderMateInfo;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.security.impl.SecurityManager;
import servermate.ServerMate;
import servermate.client.rmi.ServerMateEndPoint;
import servermate.client.rmi.ServerMateRMIClient;
import servermate.client.rmi.ServerMateRMIClientHandler;
import servermate.events.ServerMateEvent;
import servermate.events.ServerMateEventPublisher;
import servermate.events.ServerMateEventType;
import servermate.security.PersistentLicenseChecker;

public class ServerMateEndPointImpl
extends UnicastRemoteObject
implements ServerMateEndPoint {
    private ServerMateRMIClientHandler handler;
    private TaskInterrupter interrupter;

    public ServerMateEndPointImpl(ServerMateRMIClientHandler handler, TaskInterrupter interrupter) throws RemoteException {
        this.handler = handler;
        this.interrupter = interrupter;
    }

    @Override
    public void addServerMateClient(ServerMateRMIClient client) throws RemoteException {
        this.handler.addServerMateClient(client);
    }

    @Override
    public String getOrderMateInfo() throws RemoteException {
        return OrderMateInfo.getInfoString();
    }

    @Override
    public void doClearDocketCache() throws RemoteException {
        CacheManager.getInstance().clearEntireCache();
        GroovyDocket.clearGroovyDockets();
    }

    @Override
    public boolean checkDatabase() throws RemoteException {
        return Data.dbMaintenance.checkDatabase(null);
    }

    @Override
    public void repair() throws RemoteException {
        Data.dbMaintenance.repair(null);
    }

    @Override
    public void optimize() throws RemoteException {
        Data.dbMaintenance.optimizeDatabase();
    }

    @Override
    public String getIPAddress() throws RemoteException {
        return IPAddressUtils.getIPAddress();
    }

    @Override
    public void shutdownServerMate() throws RemoteException {
        ServerMateEventPublisher.publishEvent(new ServerMateEvent(ServerMateEventType.SHUTDOWN, "Shutdown", 1));
        ServerMateEventPublisher.shutdown();
        System.exit(0);
    }

    @Override
    public String getRecordedMacAddress() throws RemoteException {
        return SecurityManager.getSecurityDetails().getRecordedMacAddress();
    }

    @Override
    public void setRecordedMacAddreses(String macAddreses) throws RemoteException {
        SecurityManager.getSecurityDetails().setRecordedMacAddress(macAddreses);
    }

    @Override
    public int getNumWaitermateTerminals() throws RemoteException {
        return SecurityManager.getSecurityDetails().getNumWaitermateTerminals();
    }

    @Override
    public void setNumWaitermateTerminals(int num) throws RemoteException {
        SecurityManager.getSecurityDetails().setNumWaitermateTerminals(num);
    }

    @Override
    public String getLicenseHash() throws RemoteException {
        return SecurityManager.getSecurityDetails().getLicenseHash();
    }

    @Override
    public void setLicenseHash(String licenseHash) throws RemoteException {
        SecurityManager.getSecurityDetails().setLicenseHash(licenseHash);
        OrderMate.LOG.info("PersistentLicenseChecker isLicenseValid in SetLicenseHash" + PersistentLicenseChecker.check());
    }

    @Override
    public Date getExpiryDate() throws RemoteException {
        return SecurityManager.getSecurityDetails().getExpiryDate();
    }

    @Override
    public void setExpiryDate(Date expiryDate) throws RemoteException {
        SecurityManager.getSecurityDetails().setExpiryDate(expiryDate);
    }

    @Override
    public Date getLastRunDate() throws RemoteException {
        return SecurityManager.getSecurityDetails().getLastRunDate();
    }

    @Override
    public void setLastRunDate(Date lastRunDate) throws RemoteException {
        SecurityManager.getSecurityDetails().setLastRunDate(lastRunDate);
    }

    @Override
    public void setDBUserName(String dbUserName) throws RemoteException {
        SecurityManager.getSecurityDetails().setDBUsername(dbUserName);
    }

    @Override
    public void setTaskInterrupter() throws RemoteException {
        if (!this.interrupter.isInterrupt()) {
            this.interrupter.setInterrupt();
        }
    }

    @Override
    public boolean isStarted() throws RemoteException {
        return ServerMate.isStarted();
    }

    @Override
    public boolean isAlive() throws RemoteException {
        return true;
    }
}

