/*
 * Decompiled with CFR 0.152.
 */
package servermate.failover;

import au.com.ordermate.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.database.hardware.Terminal;
import servermate.failover.ActingMasterPanel;
import servermate.failover.FailoverManager;
import servermate.failover.FailoverPanel;
import servermate.failover.MasterPanel;
import servermate.failover.SlavePanel;

class FailoverFrame
extends JFrame {
    private static final int RECONNECT_SLEEP = 3000;
    private JTextArea statusArea;
    private FailoverPanel mainPanel;
    private FailoverManager manager;

    FailoverFrame(FailoverManager failoverManager) {
        this.manager = failoverManager;
        this.setupComponents();
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.pack();
    }

    private void setupComponents() {
        this.installAppropriatePanel();
        this.doStatusLabels();
    }

    void installAppropriatePanel() {
        FailoverSetup setup;
        if (this.mainPanel != null) {
            this.mainPanel.disconnectSignals();
            this.remove(this.mainPanel);
        }
        this.mainPanel = !(setup = this.manager.getSetup()).isSlave() ? new MasterPanel(this.manager) : (setup.isActingMaster() ? new ActingMasterPanel(this.manager) : new SlavePanel(this.manager));
        this.add((Component)this.mainPanel, "Center");
    }

    @Override
    public void dispose() {
        this.mainPanel.disconnectSignals();
        super.dispose();
    }

    private void doStatusLabels() {
        JPanel holder = new JPanel(new BorderLayout());
        holder.setPreferredSize(new Dimension(200, 120));
        this.statusArea = new JTextArea(3, 40);
        holder.add((Component)this.statusArea, "Center");
        this.statusArea.setLineWrap(true);
        this.statusArea.setWrapStyleWord(true);
        this.statusArea.setEditable(false);
        this.getContentPane().add((Component)holder, "North");
        this.setupStatusLabel();
    }

    private void setupStatusLabel() {
        Pair<String, Color> status = this.mainPanel.getStatus();
        this.pushText((String)status.getKey(), (Color)status.getValue());
        this.setTitle(this.mainPanel.getTitle());
    }

    void managerBusy(boolean isBusy) {
        this.mainPanel.setButtonsEnabled(!isBusy);
    }

    void askToFailover() {
        this.mainPanel.askToFailover();
        this.pack();
        this.requestFocus();
    }

    void doCanConnect() {
        boolean shouldClose = this.mainPanel.canConnect();
        this.doStatusLabels();
        this.pack();
        if (shouldClose) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    OrderMate.LOG.info("Connection re-established, hiding gui.");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FailoverFrame.this.setVisible(false);
                        }
                    });
                }
            }).start();
        }
    }

    void pushText(String string, Color colour) {
        this.statusArea.setText(string);
        this.statusArea.setForeground(colour == null ? Color.GRAY : colour);
    }

    public void updateTableModel(Map<Terminal, Date> pokeMap) {
        if (this.mainPanel instanceof MasterPanel) {
            ((MasterPanel)this.mainPanel).updateTableModel(pokeMap);
        }
    }
}

